# Tokyo Food Areas by Cuisine

## Best Areas by Food Type

### Sushi

| Area | Style | Price | Notes |
|------|-------|-------|-------|
| **Ginza** | High-end omakase | ¥¥¥¥ | World-famous, book ahead |
| **Tsukiji/Toyosu** | Fresh market | ¥¥-¥¥¥¥ | Early morning best |
| **Shibuya** | Casual to mid-range | ¥¥-¥¥¥ | Convenient, varied |
| **Tokyo Station** | Quick quality | ¥¥ | Excellent for travelers |

**Specific recommendations**:
- **Budget**: Sushi Zanmai (chain, 24h some locations)
- **Mid-range**: Midori Sushi (Shibuya, worth the wait)
- **Splurge**: Book through Omakase.in for verified quality

---

### Ramen

| Area | Specialty | Notes |
|------|-----------|-------|
| **Ramen Street (Tokyo Station)** | Various | 8 famous shops, tourist-friendly |
| **Ikebukuro** | Diverse | High concentration, many styles |
| **Ogikubo** | Tokyo shoyu | Classic style |
| **Nakano** | Hidden gems | Local favorites |
| **Shinjuku** | Late night | Open until 4-5am |

**Famous shops by style**:
- **Shoyu**: Fuunji (Shinjuku), Ippudo (chain, reliable)
- **Tonkotsu**: Ichiran (chain, solo booths), Ippudo
- **Tsukemen**: Rokurinsha (Tokyo Station), Fuunji
- **Miso**: Misoya (various)

---

### Yakitori

| Area | Vibe | Notes |
|------|------|-------|
| **Yurakucho** | Under the tracks | Classic Tokyo experience |
| **Meguro** | Local spots | Quality focused |
| **Ebisu** | Trendy | Higher-end options |
| **Shinjuku Omoide Yokocho** | Nostalgic | Smoky, atmospheric |

**The Yurakucho experience**:
- Under JR tracks near Yurakucho/Ginza
- Smoky, tight, standing or cramped seating
- Order beer, point at what you want
- Authentic salaryman atmosphere

---

### Izakaya

| Area | Character | Price |
|------|-----------|-------|
| **Shinjuku (Omoide Yokocho)** | Nostalgic alleys | ¥¥ |
| **Golden Gai** | Tiny bars, character | ¥¥-¥¥¥ |
| **Ebisu** | Trendy, quality | ¥¥¥ |
| **Shibuya (Nonbei Yokocho)** | Hidden gem | ¥¥ |
| **Sangenjaya** | Local favorite | ¥¥ |
| **Koenji** | Bohemian | ¥-¥¥ |

**Golden Gai tips**:
- 6-street district of 200+ tiny bars
- Many have cover charges (¥500-1,000)
- Some prefer regulars, look for "tourists welcome" signs
- Best experienced 20:00-midnight
- Each bar holds 4-10 people

---

### Tempura

| Area | Level | Notes |
|------|-------|-------|
| **Ginza** | High-end | Counter omakase style |
| **Nihonbashi** | Traditional | Historic area |
| **Anywhere** | Casual | Tenya chain, reliable |

---

### Tonkatsu

| Area | Notable Shops |
|------|---------------|
| **Omotesando** | Maisen (famous, queue) |
| **Meguro** | Tonki (legendary) |
| **Takadanobaba** | Butagumi |
| **Various** | Matsunoya (chain, value) |

---

### Wagyu / Yakiniku

| Area | Style | Price |
|------|-------|-------|
| **Shibuya** | Trendy yakiniku | ¥¥¥ |
| **Shinjuku** | Variety | ¥¥-¥¥¥¥ |
| **Ginza** | High-end | ¥¥¥¥ |

**Types**:
- **Yakiniku**: Korean BBQ style, grill your own
- **Teppanyaki**: Chef grills for you, theatrical
- **Sukiyaki/Shabu**: Hot pot style

---

### Coffee

| Area | Scene |
|------|-------|
| **Kiyosumi-Shirakawa** | Tokyo's coffee capital, Blue Bottle flagship |
| **Daikanyama** | Trendy cafes, T-Site culture |
| **Nakameguro** | Instagram-worthy spots |
| **Shimokitazawa** | Indie, local roasters |
| **Ginza** | Classic kissaten (old-style cafes) |

**Kissaten (old-style cafes)**:
- Thick slice toast with butter
- Hand-dripped coffee
- Retro atmosphere, smoking sometimes allowed
- Try: Cafe de L'Ambre (Ginza), oldest specialty coffee

---

### Sweets & Desserts

| Area | Known For |
|------|-----------|
| **Harajuku/Omotesando** | Trendy cafes, crepes, Instagram |
| **Jiyugaoka** | Patisseries, Mont Blanc famous |
| **Ginza** | High-end confections |
| **Asakusa** | Traditional Japanese sweets |
| **Depachika (any)** | Packaged sweets, gifts |

**Japanese sweets (wagashi)**:
- Asakusa: Traditional shops near Senso-ji
- Toraya: Famous yokan (sweet bean jelly)
- Department store gift floors

**Western sweets**:
- Pierre Hermé (Aoyama)
- Sadaharu Aoki (multiple)
- Henri Charpentier (multiple)

---

### International Cuisine

| Cuisine | Best Area |
|---------|-----------|
| **French** | Ginza, Omotesando |
| **Italian** | Ebisu, Daikanyama |
| **Chinese** | Yokohama Chinatown (30min), Ikebukuro |
| **Korean** | Shin-Okubo (Korea Town) |
| **Indian** | Nishi-Kasai, Shinjuku |
| **Thai** | Scattered, no district |
| **American** | Roppongi, Shibuya |

**Shin-Okubo (Korea Town)**:
- North of Shinjuku Station
- Authentic Korean BBQ, fried chicken
- K-pop shops, cosmetics
- Crowded weekends

**Yokohama Chinatown**:
- Largest in Japan
- 30min from Shibuya/Shinagawa
- Worth a half-day trip
- Dim sum, Cantonese, Sichuan, all styles

---

## By Time of Day

### Breakfast (7:00-10:00)

| Type | Where |
|------|-------|
| Japanese set | Yoshinoya, Matsuya (chains) |
| Western | Hotel buffets, Starbucks |
| Coffee + toast | Kissaten, Komeda's Coffee |
| Market fresh | Tsukiji (early) |

### Lunch (11:30-14:00)

**Best value time** — Lunch sets (定食) are 30-50% cheaper than dinner equivalents.

| Looking for | Try |
|-------------|-----|
| Quick & cheap | Chain teishoku, ramen |
| Business lunch | Department store restaurants |
| Quality affordable | Lunch omakase at sushi/kaiseki |

### Dinner (18:00-22:00)

Prime time. Popular places fill up 19:00-20:00.

**No reservation**: Chains, standing bars, ramen
**Reservation helpful**: Mid-range izakaya, specialty shops
**Reservation required**: High-end, Michelin, popular

### Late Night (22:00-05:00)

| Craving | Where |
|---------|-------|
| Ramen | Shinjuku, Shibuya (shops open til 4-5am) |
| Izakaya | Shinjuku, Shibuya, Roppongi |
| Konbini | Everywhere, 24/7 |
| Diner style | Jonathan's, Gusto (family restaurants) |

---

## Food Streets & Alleys

### Yokocho (横丁) — Historic Alleys

| Name | Location | Vibe |
|------|----------|------|
| **Omoide Yokocho** | Shinjuku | Smoky, nostalgic, yakitori |
| **Golden Gai** | Shinjuku | Tiny bars, character |
| **Nonbei Yokocho** | Shibuya | Hidden, local |
| **Yurakucho** | Ginza/Yurakucho | Under-track izakaya |
| **Harmonica Yokocho** | Kichijoji | Retro, indie |

### Modern Food Courts

| Location | What to Know |
|----------|--------------|
| **Tokyo Station (Ramen Street)** | 8 famous ramen shops, touristy but quality |
| **Tokyo Station (Kitchen Street)** | Variety beyond ramen |
| **Shibuya Stream/Scramble Square** | Modern, trendy options |
| **Roppongi Hills** | Upscale variety |
