# Japanese Culture & Etiquette Guide

## Core Cultural Concepts

### Harmony (和 / Wa)

**The foundation of Japanese society.**

- Avoid conflict and confrontation
- Group harmony over individual expression
- Indirect communication preferred
- "Reading the air" (空気を読む / kuuki wo yomu)

**In practice**: Japanese people may say "yes" (はい) when they mean "I understand" not "I agree."

### Face (面子 / Mentsu)

**Maintaining dignity and reputation.**

- Don't embarrass others publicly
- Accept compliments modestly
- Criticism should be private and gentle
- Saving face is paramount

### Hierarchy (上下関係 / Jouge Kankei)

**Respect based on age, position, seniority.**

- Use honorific language (敬語)
- Defer to seniors in conversation
- Business cards reflect position
- Bowing depth indicates respect level

---

## Daily Etiquette

### Greetings

| Situation | What to Do |
|-----------|------------|
| Meeting someone | Bow (15-30°), say こんにちは (konnichiwa) |
| Business meeting | Exchange cards, bow, use -san suffix |
| Entering shop | Staff says いらっしゃいませ (irasshaimase), no response needed |
| Thank you | ありがとうございます (arigatou gozaimasu) + slight bow |
| Sorry/Excuse me | すみません (sumimasen), versatile word |

### Bowing (お辞儀 / Ojigi)

| Depth | When |
|-------|------|
| 15° (eshaku) | Casual greeting, passing |
| 30° (keirei) | Standard greeting, thank you |
| 45° (saikeirei) | Deep apology, high respect |

**Tip**: Foreigners aren't expected to bow perfectly. A slight bow shows respect.

### Personal Space

- Crowded trains: Personal space abandoned, accepted
- Standing: Keep reasonable distance
- Conversation: Arm's length typical
- Touching: Avoid touching others (no hugs, limited handshakes)

---

## Public Behavior

### On Trains

| Do | Don't |
|----|-------|
| Keep quiet | Talk on phone |
| Stand on left (escalators) | Eat or drink (technically) |
| Offer seat to elderly/pregnant | Block doors |
| Put phone on silent/manner mode | Play games with sound |

### Walking

| Do | Don't |
|----|-------|
| Walk on left side | Eat while walking |
| Queue orderly | Block pathways |
| Be aware of others | Talk loudly |

**Eating while walking**: Generally inappropriate except at festivals or designated areas. Buy, step aside, eat, then continue.

### In Public

- **Blowing nose**: Do it privately, not in public
- **Yawning**: Cover mouth
- **Pointing**: Use open hand gesture
- **Loud conversations**: Keep voice down
- **Garbage**: Carry it home (few public trash cans)

---

## Dining Etiquette

### Before Eating

1. **Oshibori** (wet towel): Wipe hands only (not face)
2. **Itadakimasu** (いただきます): Say before eating ("I humbly receive")
3. **Wait for everyone**: Begin together

### Chopstick Rules

| Don't |
|-------|
| Stick upright in rice (funeral imagery) |
| Pass food chopstick-to-chopstick (funeral ritual) |
| Point with chopsticks |
| Stab food |
| Rub chopsticks together (implies cheap quality) |

### Drinking

- **Pour for others first**: Don't pour your own
- **Wait for toast**: 乾杯 (kanpai) before drinking
- **Drinking hierarchy**: Junior pours for senior

### Finishing

- **Finish your rice**: Leaving food is wasteful
- **Gochisosama deshita** (ごちそうさまでした): Say after eating
- **Tipping**: NEVER tip in Japan

---

## Visiting Homes

### If Invited

**Rare honor** — Japanese often meet outside home.

| Do | Don't |
|----|-------|
| Bring gift (food, sweets) | Arrive empty-handed |
| Remove shoes at entrance | Walk on tatami with socks off |
| Compliment the home modestly | Snoop around |
| Leave at reasonable time | Overstay welcome |

### Shoes

**Always remove at**:
- Homes
- Traditional restaurants
- Temples (some areas)
- Hotels (in room)
- Fitting rooms

**Look for**: Genkan (entrance area), slippers provided.

---

## Business Culture

### Business Cards (名刺 / Meishi)

**Extremely important ritual.**

| Step | Action |
|------|--------|
| 1 | Present with both hands, text facing recipient |
| 2 | Receive with both hands |
| 3 | Study the card respectfully |
| 4 | Place on table during meeting |
| 5 | Store carefully (never in back pocket) |

### Meetings

- **Punctuality**: Arrive 5-10 minutes early
- **Seating**: Wait to be seated, hierarchy matters
- **Decisions**: Not made in meetings (consensus built before)
- **Silence**: Comfortable, means thinking
- **No means maybe**: Direct "no" is rare

### Work Culture

- **Long hours**: Traditional, changing slowly
- **Nomikai** (飲み会): After-work drinking, semi-mandatory
- **Hierarchy**: Strong, affects all interactions
- **Group over individual**: Team achievements celebrated

---

## Religious & Spiritual Sites

### Shrines (神社 / Jinja) — Shinto

**How to visit**:
1. Bow at torii gate before entering
2. Walk on sides (center is for gods)
3. Purify at temizuya (water basin)
4. At main hall: bow twice, clap twice, pray, bow once
5. Throw coin, ring bell if present

### Temples (寺 / Tera) — Buddhist

**How to visit**:
1. Bow at entrance
2. Purify with incense smoke (optional)
3. Bow, pray quietly (no clapping)
4. Respect worshippers

### General Rules

- Dress modestly (shoulders, knees)
- Quiet, respectful behavior
- No photos during ceremonies
- Follow local signs

---

## Gift-Giving (贈り物 / Okurimono)

### When to Give

- Visiting someone's home
- Business meetings (first meeting especially)
- Returning from travel (omiyage)
- Seasonal gifts (summer: ochugen, winter: oseibo)
- Gratitude occasions

### What to Give

**Good gifts**:
- Quality food/sweets from your region or famous maker
- Alcohol (if they drink)
- Fruit (expensive fruit is luxury item)
- Department store items (packaging matters)

**Avoid**:
- Sets of 4 (four = death 死)
- White flowers (funeral)
- Clocks (time running out)
- Sharp objects (cutting ties)

### How to Give

- Present with both hands
- Say つまらないものですが (tsumaranai mono desu ga) — "This is nothing special"
- Recipient may not open immediately (normal)

---

## Taboos & Sensitive Topics

### Topics to Avoid

- WWII (especially with older generation)
- Controversial politics
- Personal income/salary
- Age/weight (especially women)
- Direct criticism

### Social Taboos

- Tipping (insulting)
- Showing too much emotion publicly
- Public displays of affection (beyond hand-holding)
- Being too direct
- Conflict in public

### Tattoos

**Historical association with yakuza (organized crime).**

**Impact**:
- Many onsen/sento ban tattooed people
- Some gyms restrict
- May affect job prospects (traditional companies)

**Solutions**:
- Cover with bandages/patches at some onsen
- Private onsen rooms
- Tattoo-friendly establishments exist (growing)

---

## Understanding "Yes"

**Japanese "yes" (はい/hai) can mean**:
- Yes, I agree
- Yes, I understand
- Yes, I'm listening
- I hear you (not agreement)

**How to clarify**: Ask specific questions.

**"No" alternatives**:
- ちょっと... (chotto...) — "It's a bit..."
- 難しいですね (muzukashii desu ne) — "It's difficult"
- 考えておきます (kangaete okimasu) — "I'll think about it"

These often mean "no" without saying no directly.

---

## Adapting as a Foreigner

### Expectations

- **You won't be expected** to know everything
- **Efforts are appreciated** — trying shows respect
- **Mistakes are forgiven** — intention matters
- **"Gaijin pass"** — some rules relaxed for foreigners

### Building Trust

- Learn basic Japanese
- Observe before acting
- Ask when unsure
- Show appreciation for help
- Be patient with processes

### Cultural Bridge

**Best approach**: Respectful curiosity without judgment. Japan does things differently, not wrong.
