# Tokyo Cost of Living (2026)

## Quick Summary

| Lifestyle | Monthly Budget |
|-----------|----------------|
| Student/Tight | ¥150,000-180,000 |
| Moderate | ¥230,000-280,000 |
| Comfortable | ¥300,000-400,000 |
| Premium | ¥450,000+ |

---

## Housing

### Rent by Area (1K/1R Studio)

| Area Type | Monthly Rent | Example Areas |
|-----------|--------------|---------------|
| Premium central | ¥150,000-200,000+ | Minato, central Shibuya |
| Central | ¥110,000-150,000 | Meguro, Shinjuku, Shibuya outskirts |
| Moderate | ¥90,000-110,000 | Nakano, Bunkyo, Setagaya |
| Budget | ¥70,000-90,000 | Nerima, Adachi, Edogawa |

### Rent by Size

| Type | Size | Central | Outer |
|------|------|---------|-------|
| 1K/1R | 15-25㎡ | ¥95,000-130,000 | ¥70,000-100,000 |
| 1DK | 25-30㎡ | ¥120,000-160,000 | ¥90,000-120,000 |
| 1LDK | 35-45㎡ | ¥150,000-220,000 | ¥110,000-160,000 |
| 2LDK | 50-65㎡ | ¥200,000-300,000 | ¥150,000-220,000 |
| 3LDK | 70-90㎡ | ¥280,000-450,000 | ¥200,000-300,000 |

### Move-in Costs

**Expect to pay 3-5 months' rent upfront:**

| Item | Typical Amount |
|------|----------------|
| First month rent | 1 month |
| Security deposit | 1-2 months |
| Key money (礼金) | 0-1 month |
| Agency fee | 1 month |
| Guarantor company | 0.5-1 month |
| Lock change/cleaning | ¥20,000-50,000 |

**Example**: ¥100,000 rent = ¥350,000-500,000 upfront.

### Alternative Housing

| Type | Monthly Cost | Pros | Cons |
|------|--------------|------|------|
| Share house | ¥50,000-90,000 | Low upfront, furnished | Shared spaces |
| Social apartment | ¥80,000-120,000 | Community, events | Less privacy |
| Serviced apt | ¥150,000-300,000 | Furnished, flexible | Expensive |

---

## Utilities

### Monthly Costs (Single Person)

| Utility | Average | Range |
|---------|---------|-------|
| Electricity | ¥8,000-12,000 | Higher summer/winter |
| Gas | ¥5,000-8,000 | Higher winter |
| Water | ¥4,000-6,000 | Billed bi-monthly |
| Internet | ¥4,500-6,500 | Fiber |
| Mobile | ¥2,000-8,000 | Depends on plan |

**Total utilities**: ¥23,500-40,500/month

### Saving on Utilities

- **Electricity**: LED bulbs, turn off AC when out
- **Gas**: Shorter showers, cook efficiently
- **Mobile**: MVNO carriers (Rakuten, LINEMO) from ¥2,000

---

## Food

### Monthly Food Budget

| Style | Monthly | Daily |
|-------|---------|-------|
| Cook at home | ¥35,000-45,000 | ¥1,200-1,500 |
| Mix (cook + eat out) | ¥50,000-70,000 | ¥1,700-2,300 |
| Mostly eat out | ¥80,000-120,000 | ¥2,700-4,000 |

### Meal Costs

| Meal Type | Cost |
|-----------|------|
| Konbini onigiri | ¥120-200 |
| Konbini bento | ¥400-700 |
| Chain restaurant | ¥500-900 |
| Ramen | ¥850-1,200 |
| Lunch teishoku | ¥800-1,200 |
| Izakaya dinner | ¥2,500-4,000 |
| Nice restaurant | ¥5,000-10,000 |

### Grocery Prices

| Item | Supermarket | Notes |
|------|-------------|-------|
| Rice (5kg) | ¥1,800-2,500 | Essential staple |
| Eggs (10) | ¥200-350 | |
| Milk (1L) | ¥180-250 | |
| Bread (loaf) | ¥120-200 | |
| Chicken breast (100g) | ¥80-120 | |
| Beef (100g) | ¥200-500+ | |
| Vegetables | ¥100-300 | Per item |
| Fruit | ¥200-500+ | Often expensive |

### Cheap Eating Tips

- **Gyomu Super**: Bulk items, restaurant supply prices
- **OK Store**: Consistently low prices
- **Time discounts**: Supermarkets mark down 20-50% after 8pm
- **Lunch over dinner**: Same restaurant, 30-50% cheaper

---

## Transportation

### Daily Commute

| Option | Monthly Cost |
|--------|--------------|
| Commuter pass | ¥8,000-15,000 |
| Pay-as-you-go | ¥6,000-12,000 |
| Bicycle | ¥0 (own) or ¥3,000-5,000 (rental) |

### Other Transport

| Transport | Cost |
|-----------|------|
| Single train ride | ¥170-400 |
| Taxi (typical ride) | ¥1,000-2,000 |
| Shinkansen to Kyoto | ¥13,320 (one way) |

---

## Healthcare

### National Health Insurance

**For self-employed/students**:
- Based on income
- Average: ¥15,000-25,000/month
- Covers 70% of costs

**Employee insurance**:
- Split with employer
- Automatically deducted

### Medical Costs (After Insurance)

| Service | Your Cost (30%) |
|---------|-----------------|
| Doctor visit | ¥1,000-3,000 |
| Prescription | ¥500-2,000 |
| Dental cleaning | ¥2,000-4,000 |
| Specialist | ¥3,000-5,000 |

---

## Entertainment & Lifestyle

### Monthly Entertainment

| Activity | Cost |
|----------|------|
| Movie ticket | ¥1,900-2,100 |
| Gym membership | ¥8,000-15,000 |
| Haircut (men) | ¥3,000-5,000 |
| Haircut (women) | ¥5,000-10,000 |
| Night out (dinner + drinks) | ¥5,000-10,000 |
| Coffee at cafe | ¥400-700 |
| Beer at convenience store | ¥200-300 |
| Beer at bar | ¥500-800 |

### Subscriptions

| Service | Monthly |
|---------|---------|
| Netflix | ¥990-1,980 |
| Spotify | ¥980 |
| Amazon Prime | ¥600 |
| Gym (chain) | ¥7,000-10,000 |
| Gym (premium) | ¥12,000-20,000 |

---

## Sample Monthly Budgets

### Student / Minimum Budget

| Category | Amount |
|----------|--------|
| Rent (share house) | ¥55,000 |
| Utilities | ¥10,000 |
| Food (cook mostly) | ¥35,000 |
| Transport | ¥8,000 |
| Phone | ¥3,000 |
| Insurance | ¥8,000 |
| Entertainment | ¥10,000 |
| Misc | ¥10,000 |
| **Total** | **¥139,000** |

### Young Professional

| Category | Amount |
|----------|--------|
| Rent (1K, moderate area) | ¥95,000 |
| Utilities | ¥18,000 |
| Food (mix) | ¥55,000 |
| Transport | ¥12,000 |
| Phone | ¥5,000 |
| Insurance | ¥20,000 |
| Entertainment | ¥25,000 |
| Misc | ¥20,000 |
| **Total** | **¥250,000** |

### Professional / Comfortable

| Category | Amount |
|----------|--------|
| Rent (1LDK, nice area) | ¥160,000 |
| Utilities | ¥22,000 |
| Food (nice restaurants) | ¥80,000 |
| Transport | ¥15,000 |
| Phone | ¥8,000 |
| Insurance | ¥25,000 |
| Entertainment | ¥50,000 |
| Savings | ¥40,000 |
| **Total** | **¥400,000** |

### Family (2 adults, 1 child)

| Category | Amount |
|----------|--------|
| Rent (2LDK) | ¥200,000 |
| Utilities | ¥30,000 |
| Food | ¥100,000 |
| Transport | ¥20,000 |
| Insurance | ¥40,000 |
| Childcare/School | ¥50,000 |
| Entertainment | ¥40,000 |
| Misc | ¥30,000 |
| **Total** | **¥510,000** |

---

## Salary Context

### Average Salaries (Annual)

| Role | Salary Range |
|------|--------------|
| Fresh graduate | ¥3.5M-4.5M |
| Mid-career | ¥5M-8M |
| Senior professional | ¥8M-15M |
| Manager | ¥10M-20M |
| Tech (foreign company) | ¥8M-20M+ |

### Tax Deductions

Rough take-home after taxes/insurance:
- ¥5M salary → ~¥4M take-home
- ¥8M salary → ~¥6M take-home
- ¥12M salary → ~¥8.5M take-home

### Rule of Thumb

Keep rent below 30% of take-home pay.

| Take-home | Max Rent |
|-----------|----------|
| ¥250,000 | ¥75,000 |
| ¥350,000 | ¥105,000 |
| ¥500,000 | ¥150,000 |
