---
name: Tokyo
slug: tokyo
version: 1.0.0
homepage: https://clawic.com/skills/tokyo
description: Navigate Tokyo as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, safety, culture, and local insights.
metadata: {"clawdbot":{"emoji":"🗼","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Tokyo for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Central (Minato, Shibuya, Shinjuku) | `neighborhoods-central.md` |
| Residential (Meguro, Setagaya) | `neighborhoods-residential.md` |
| East (Asakusa, Ueno, Sumida) | `neighborhoods-east.md` |
| Outer (Kichijoji, Nerima) | `neighborhoods-outer.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining culture | `food-overview.md` |
| Traditional (sushi, ramen, etc.) | `food-traditional.md` |
| Markets & depachika | `food-markets.md` |
| Best areas by cuisine | `food-areas.md` |
| Etiquette & practical tips | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (JR, Metro, IC cards) | `transport.md` |
| Cost of living | `cost.md` |
| Safety | `safety.md` |
| Weather & seasons | `climate.md` |
| Local services | `local.md` |
| **Culture** | |
| Etiquette & customs | `culture.md` |
| **Career** | |
| Tech industry | `tech.md` |
| Students | `student.md` |
| Startups | `startup.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- **Japanese level**: None, basic, conversational, fluent
- Load relevant auxiliary file for details

### 2. Safety Context
Tokyo is one of the world's safest major cities. Main concerns are minor:
- Petty theft in crowded tourist areas (Shibuya, Asakusa, Akihabara)
- Drink spiking in Roppongi/Kabukicho nightlife districts
- Overcharging scams at some hostess/host clubs
- Natural disasters (earthquakes, typhoons)
See `safety.md` for detailed guidance.

### 3. Weather Expectations
- Four distinct seasons
- Summer (Jun-Sep): Hot, humid (30-35°C), rainy season in June
- Winter (Dec-Feb): Cold, dry (5-10°C), rarely snows
- Best months: March-May (cherry blossoms), October-November (autumn leaves)
- Typhoon season: August-October
See `climate.md` for monthly breakdown.

### 4. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1K/1R rent (studio) | ¥95,000-130,000 (central), ¥70,000-100,000 (outer) |
| 1LDK rent | ¥140,000-220,000 |
| Senior SWE salary | ¥7M-12M/year |
| Student budget | ¥150,000-200,000/month |
| Suica/Pasmo fare | ¥180-260/ride |
| Monthly transit pass | ¥8,000-15,000 |

### 5. Tourist Traps
- Skip: Overpriced tourist ramen in Shibuya crossing area
- Do: Standing sushi near Tsukiji/Toyosu, local izakaya in Yurakucho
- Watch: Roppongi "free drink" touts (lead to overcharging scams)
- Free: Meiji Shrine, Imperial Palace East Gardens, Senso-ji Temple
- Golden Gai bars welcome foreigners but have ¥500-1000 cover charges

### 6. Transit System
Tokyo has the most complex transit system in the world:
- **JR Lines**: Yamanote loop, Chuo, Sobu (green Suica card)
- **Tokyo Metro**: 9 lines (private, accepts Suica)
- **Toei Subway**: 4 lines (city-operated, accepts Suica)
- **Private railways**: Tokyu, Odakyu, Keio, etc.
- **IC cards**: Suica/Pasmo interchangeable, use everywhere
See `transport.md` for full guide.

### 7. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Shibuya, Nakameguro, Ebisu |
| Families | Setagaya, Meguro, Kichijoji |
| Budget-conscious | Nerima, Adachi, Edogawa |
| Tech workers | Shibuya, Roppongi, Shinagawa |
| Traditional vibes | Asakusa, Yanaka, Kagurazaka |
| Nightlife seekers | Shinjuku, Roppongi, Shibuya |

## Language Context

### Japanese Language Reality

Unlike many global cities, English proficiency is limited:

| Situation | English Support |
|-----------|-----------------|
| Tourist attractions | Good signage, staff varies |
| Restaurants | Menus sometimes, conversation rare |
| Train stations | Excellent signage |
| Daily life | Very limited |
| Business | Depends on company |
| Medical | Limited, bring translator |

**Practical advice:**
- Learn basic Japanese phrases
- Google Translate camera mode works well for menus
- Download offline Japanese in Google Translate
- Major chains (Starbucks, McDonald's) have English menus
- Hospital/clinic visits often need interpreter

### Essential Phrases

| Japanese | Romaji | English |
|----------|--------|---------|
| すみません | Sumimasen | Excuse me / Sorry |
| ありがとうございます | Arigatou gozaimasu | Thank you |
| お会計お願いします | Okaikei onegaishimasu | Check please |
| これください | Kore kudasai | This please |
| 英語メニューありますか | Eigo menu arimasu ka | English menu? |
| いくらですか | Ikura desu ka | How much? |

## Tokyo-Specific Traps

- **Roppongi touts** — "Free drinks" lead to ¥50,000+ bills. Never follow strangers.
- **Kabukicho host/hostess clubs** — Can run ¥100,000+ per visit. Avoid unless invited by locals.
- **Fake monks** — Aggressive "donation" requests near Asakusa. Real monks don't approach tourists.
- **Rush hour** (7:30-9:30am) — Trains packed 200%+ capacity. Avoid if possible.
- **Airport taxi** — ¥20,000+ to central Tokyo. Use Limousine Bus (¥3,200) or train (¥1,200-2,500).
- **"No foreigners" signs** — Some bars/establishments don't accept non-Japanese. Don't take it personally.
- **Cash is king** — Many places still don't accept cards. Carry ¥10,000-20,000.
- **Tipping** — Never tip. It's considered rude.
- **Walking while eating** — Culturally inappropriate except at festivals.
- **Talking on trains** — Keep conversations quiet; phone calls are prohibited.

## Visa & Residency Quick Reference

| Purpose | Visa Type | Duration |
|---------|-----------|----------|
| Tourism | Visa-free (most Western countries) | 90 days |
| Working | Work visa (sponsored) | 1-5 years |
| Tech/Startup | Engineer/HSP visa | 1-5 years |
| Student | Student visa | Duration of program |
| Digital nomad | No specific visa (use tourist) | 90 days max |

**Note**: Japan has no digital nomad visa. Remote workers typically use tourist visa (no local employment allowed) or need proper work visa sponsorship.
