---
name: token-manager
description: Universal LLM Token Manager - Monitor usage and provide cost-saving recommendations for Kimi, OpenAI, Anthropic, Gemini, and local models. Features scheduled monitoring, cross-session tracking, and proactive alerts.
---

# Token Manager

Universal LLM Token Manager with proactive monitoring and analytics.

## When to Use

Use this skill when you need to:
- Monitor LLM API token usage and costs
- Get cost-saving recommendations
- Set up automated balance alerts
- Track usage across multiple sessions
- Generate daily/weekly usage reports

## Quick Start

```bash
cd /path/to/token-manager
export MOONSHOT_API_KEY="your-api-key"

# Generate report
node scripts/manager.js report 11000 146 42000 200000 off 9.26 moonshot kimi-k2.5
```

## Core Features

### 1. Usage Monitoring
Real-time session analysis with cost-saving suggestions.

### 2. Scheduled Alerts (P0)
Automatic balance monitoring with proactive notifications.

### 3. Built-in Tool Integration (P1)
Register as OpenClaw tool for seamless usage.

### 4. Cross-Session Analytics (P2)
Track spending patterns and generate reports.

## Supported Providers

| Provider | Balance Query | Token Estimate | Pricing |
|----------|---------------|----------------|---------|
| Kimi/Moonshot | ✅ API | ✅ API | ¥12/1M tokens |
| OpenAI | ❌ Console | ❌ Approx | USD/1M tokens |
| Anthropic/Claude | ❌ Console | ❌ Approx | USD/1M tokens |
| Google/Gemini | ❌ Console | ❌ Approx | USD/1M tokens |
| Ollama/Local | N/A Free | N/A | FREE |

## Cost-Saving Recommendations

### Context Management
| Scenario | Recommendation | Action |
|----------|----------------|--------|
| Context > 80% | 🚨 Critical: Must compact immediately | `/compact` |
| Context > 50% | 📊 Suggest: Consider compacting | `/compact` |
| Session > 50k tokens | ⚠️ Warning: Split tasks now | `/spawn` |
| Session > 20k tokens | 💡 Tip: Use sub-agents for large tasks | `/spawn` |

### Reasoning Optimization
| Scenario | Recommendation | Action |
|----------|----------------|--------|
| Reasoning ON + small task (<5k tokens) | 💡 Can disable to save 20-30% | `/thinking off` |
| Reasoning ON + complex task | ✅ Keep on for quality | Keep |

### Provider-Specific Tips
| Scenario | Recommendation |
|----------|----------------|
| Balance < ¥5 | 🚨 Enable save mode, avoid large tasks |
| Using GPT-4 | 💡 Consider GPT-4o-mini for 10x savings |
| Using Claude Opus | 💡 Consider Claude Sonnet for 5x savings |
| Running Ollama | 🎉 Free! No API costs |

## Commands

### Manager (Core)
```bash
node scripts/manager.js report <tokensIn> <tokensOut> <contextUsed> <contextMax> <thinking> [balance] [provider] [model] [apiKey]
node scripts/manager.js balance [provider] [apiKey]
node scripts/manager.js estimate <provider> <inputTokens> <outputTokens> [model]
node scripts/manager.js providers
node scripts/manager.js history
```

### Scheduler (P0 - Cron Alerts)
```bash
# Check balance and alert if below threshold
node scripts/scheduler.js check <provider> <threshold>

# View alert statistics
node scripts/scheduler.js stats
```

### Session Tracker (P2 - Analytics)
```bash
# Record session for tracking
node scripts/session-tracker.js record <provider> <model> <tokensIn> <tokensOut> <cost> [currency]

# Generate reports
node scripts/session-tracker.js daily [date]
node scripts/session-tracker.js weekly
node scripts/session-tracker.js recommend
```

## P0: Scheduled Monitoring & Alerts

Setup automatic balance monitoring with cron jobs.

### Setup Cron Job

```bash
# Check every hour, alert if below ¥5
openclaw cron add \
  --name "token-balance-check" \
  --schedule "0 * * * *" \
  --command "cd /path/to/token-manager && node scripts/scheduler.js check moonshot 5"
```

### Alert Rules

| Condition | Action | Cooldown |
|-----------|--------|----------|
| Balance < threshold | Send alert | 1 hour |
| Balance < ¥1 | Send urgent alert | 30 min |
| 3 alerts in 24h | Suggest adding funds | - |

### Alert Output

When triggered, outputs JSON:
```json
{
  "alert": true,
  "balance": 3.50,
  "threshold": 5,
  "messages": {
    "en": "🚨 [URGENT] Token Manager Alert...",
    "cn": "🚨 [紧急] Token 管家提醒..."
  }
}
```

## P1: Tool Integration

Register as OpenClaw tool for direct usage.

### Tool Configuration

Add to `openclaw.json`:
```json
{
  "tools": {
    "token_status": {
      "command": "cd /path/to/token-manager && node scripts/manager.js report",
      "description": "Check current token usage and costs"
    },
    "token_balance": {
      "command": "cd /path/to/token-manager && node scripts/manager.js balance",
      "description": "Query account balance"
    }
  }
}
```

### Usage After Registration

```bash
# Direct commands
openclaw tool token_status 11000 146 42000 200000 off 9.26 moonshot
openclaw tool token_balance moonshot
```

## P2: Cross-Session Tracking

Track usage patterns across multiple sessions.

### Recording Sessions

Automatically or manually record each session:
```bash
node scripts/session-tracker.js record moonshot kimi-k2.5 5000 500 0.06 CNY
```

### Daily Report

```bash
node scripts/session-tracker.js daily
# Output: Total tokens, cost, session count, provider breakdown
```

### Weekly Report

```bash
node scripts/session-tracker.js weekly
# Output: 7-day summary with trend analysis
```

### Smart Recommendations

```bash
node scripts/session-tracker.js recommend
# Analyzes patterns and suggests optimizations
```

## Environment Variables

- `MOONSHOT_API_KEY` - Kimi/Moonshot API key
- `OPENAI_API_KEY` - OpenAI API key (optional)
- `ANTHROPIC_API_KEY` - Anthropic API key (optional)

## Security

- API keys read from environment variables only
- All data stored locally in `.data/` directory
- No data uploaded to third-party servers
- Network requests only to official LLM APIs
- Alert state persisted locally with cooldown logic

## Pricing Reference

### Kimi/Moonshot
- K2.5: ¥12 / 1M tokens

### OpenAI
- GPT-4o: $2.5 / $10 per 1M
- GPT-4o-mini: $0.15 / $0.6 per 1M
- GPT-3.5-turbo: $0.5 / $1.5 per 1M

### Anthropic
- Claude 3.5 Sonnet: $3 / $15 per 1M
- Claude 3 Opus: $15 / $75 per 1M
- Claude 3 Haiku: $0.25 / $1.25 per 1M

### Google Gemini
- Gemini 1.5 Pro: $3.5 / $10.5 per 1M
- Gemini 1.5 Flash: $0.35 / $1.05 per 1M

### Ollama
- Local execution: FREE

---

---

# Token 管家

通用 LLM Token 管理工具，支持主动监控和数据分析。

## 使用场景

在以下情况使用此 skill：
- 监控 LLM API token 使用和费用
- 获取省钱优化建议
- 设置自动余额提醒
- 追踪多会话使用模式
- 生成每日/每周使用报告

## 快速开始

```bash
cd /path/to/token-manager
export MOONSHOT_API_KEY="your-api-key"

# 生成报告
node scripts/manager.js report 11000 146 42000 200000 off 9.26 moonshot kimi-k2.5
```

## 核心功能

### 1. 使用监控
实时会话分析，提供省钱建议。

### 2. 定时提醒 (P0)
自动余额监控，主动通知。

### 3. 工具集成 (P1)
注册为 OpenClaw 工具，无缝使用。

### 4. 跨会话分析 (P2)
追踪消费模式，生成报告。

## 支持的提供商

| 提供商 | 余额查询 | Token 估算 | 价格 |
|--------|----------|------------|------|
| Kimi/Moonshot | ✅ API | ✅ API | ¥12/百万 |
| OpenAI | ❌ 控制台 | ❌ 估算 | USD/百万 |
| Anthropic/Claude | ❌ 控制台 | ❌ 估算 | USD/百万 |
| Google/Gemini | ❌ 控制台 | ❌ 估算 | USD/百万 |
| Ollama/本地 | N/A 免费 | N/A | 免费 |

## 省钱优化建议

### 上下文管理
| 场景 | 建议 | 操作 |
|------|------|------|
| 上下文 > 80% | 🚨 紧急：必须立即压缩 | `/compact` |
| 上下文 > 50% | 📊 建议：适时压缩 | `/compact` |
| 会话 > 50k tokens | ⚠️ 警告：立即拆分任务 | `/spawn` |
| 会话 > 20k tokens | 💡 提示：大任务使用子代理 | `/spawn` |

### 推理优化
| 场景 | 建议 | 操作 |
|------|------|------|
| Reasoning 开启 + 小任务 (<5k tokens) | 💡 可关闭节省 20-30% | `/thinking off` |
| Reasoning 开启 + 复杂任务 | ✅ 保持开启确保质量 | 保持 |

### 提供商特定建议
| 场景 | 建议 |
|------|------|
| 余额 < ¥5 | 🚨 开启省钱模式，避免大任务 |
| 使用 GPT-4 | 💡 考虑 GPT-4o-mini 省 10 倍 |
| 使用 Claude Opus | 💡 考虑 Claude Sonnet 省 5 倍 |
| 运行 Ollama | 🎉 免费！无 API 费用 |

## 命令

### 管理器（核心）
```bash
node scripts/manager.js report <输入tokens> <输出tokens> <上下文已用> <上下文上限> <推理状态> [余额] [提供商] [模型] [apiKey]
node scripts/manager.js balance [提供商] [apiKey]
node scripts/manager.js estimate <提供商> <输入tokens> <输出tokens> [模型]
node scripts/manager.js providers
node scripts/manager.js history
```

### 调度器 (P0 - 定时提醒)
```bash
# 检查余额，低于阈值时提醒
node scripts/scheduler.js check <提供商> <阈值>

# 查看提醒统计
node scripts/scheduler.js stats
```

### 会话追踪器 (P2 - 分析)
```bash
# 记录会话
node scripts/session-tracker.js record <提供商> <模型> <输入tokens> <输出tokens> <费用> [货币]

# 生成报告
node scripts/session-tracker.js daily [日期]
node scripts/session-tracker.js weekly
node scripts/session-tracker.js recommend
```

## P0: 定时监控与提醒

使用 cron 设置自动余额监控。

### 设置定时任务

```bash
# 每小时检查，低于 ¥5 时提醒
openclaw cron add \
  --name "token-balance-check" \
  --schedule "0 * * * *" \
  --command "cd /path/to/token-manager && node scripts/scheduler.js check moonshot 5"
```

### 提醒规则

| 条件 | 动作 | 冷却时间 |
|------|------|----------|
| 余额 < 阈值 | 发送提醒 | 1 小时 |
| 余额 < ¥1 | 发送紧急提醒 | 30 分钟 |
| 24 小时内 3 次提醒 | 建议充值 | - |

### 提醒输出

触发时输出 JSON：
```json
{
  "alert": true,
  "balance": 3.50,
  "threshold": 5,
  "messages": {
    "en": "🚨 [URGENT] Token Manager Alert...",
    "cn": "🚨 [紧急] Token 管家提醒..."
  }
}
```

## P1: 工具集成

注册为 OpenClaw 工具直接使用。

### 工具配置

添加到 `openclaw.json`：
```json
{
  "tools": {
    "token_status": {
      "command": "cd /path/to/token-manager && node scripts/manager.js report",
      "description": "Check current token usage and costs"
    },
    "token_balance": {
      "command": "cd /path/to/token-manager && node scripts/manager.js balance",
      "description": "Query account balance"
    }
  }
}
```

### 注册后使用

```bash
# 直接命令
openclaw tool token_status 11000 146 42000 200000 off 9.26 moonshot
openclaw tool token_balance moonshot
```

## P2: 跨会话追踪

追踪多会话使用模式。

### 记录会话

自动或手动记录每个会话：
```bash
node scripts/session-tracker.js record moonshot kimi-k2.5 5000 500 0.06 CNY
```

### 每日报告

```bash
node scripts/session-tracker.js daily
# 输出：总 token、费用、会话数、提供商分布
```

### 每周报告

```bash
node scripts/session-tracker.js weekly
# 输出：7 天摘要及趋势分析
```

### 智能建议

```bash
node scripts/session-tracker.js recommend
# 分析模式并提供优化建议
```

## 环境变量

- `MOONSHOT_API_KEY` - Kimi/Moonshot API 密钥
- `OPENAI_API_KEY` - OpenAI API 密钥（可选）
- `ANTHROPIC_API_KEY` - Anthropic API 密钥（可选）

## 安全说明

- API 密钥仅从环境变量读取
- 所有数据本地存储在 `.data/` 目录
- 无数据上传到第三方服务器
- 网络请求仅访问官方 LLM API
- 提醒状态本地持久化，带冷却逻辑

## 价格参考

### Kimi/Moonshot
- K2.5: ¥12 / 百万 tokens

### OpenAI
- GPT-4o: $2.5 / $10 每百万
- GPT-4o-mini: $0.15 / $0.6 每百万
- GPT-3.5-turbo: $0.5 / $1.5 每百万

### Anthropic
- Claude 3.5 Sonnet: $3 / $15 每百万
- Claude 3 Opus: $15 / $75 每百万
- Claude 3 Haiku: $0.25 / $1.25 每百万

### Google Gemini
- Gemini 1.5 Pro: $3.5 / $10.5 每百万
- Gemini 1.5 Flash: $0.35 / $1.05 每百万

### Ollama
- 本地运行：免费
