---
name: token-analyzer
version: 1.0.1
description: "提供全面的代币分析功能。通过合约地址查询代币在不同链（SOL, BSC, Base）上的实时市场数据、AI评分、风险评估和Alpha分析。已优化消息格式，并支持向个人私聊推送。适用于用户需要快速获取特定代币详细信息和投资洞察的场景。当用户提及'分析代币'、'查询代币'、'给我某个合约的分析'时使用。"
---

# Token Analyzer - 实时代币分析与洞察

## 概述

此技能允许用户通过提供代币合约地址，获取其在 Solana (SOL), Binance Smart Chain (BSC) 或 Base 链上的实时、全面的市场数据和深度分析。它利用gmgn.ai和Ave.ai等数据源，结合AI模型进行评分、风险评估和Why Alpha分析，帮助用户快速了解代币的潜在价值和风险。

## 核心能力

### 1. 多链支持与智能链检测
-   **支持链**: Solana (SOL), Binance Smart Chain (BSC), Base。
-   **自动检测**: 如果用户未指定链，技能将尝试自动检测代币所属链。

### 2. 整合多源数据
-   **gmgn.ai**: 优先从gmgn.ai内部API获取数据，利用本地Chrome DevTools Protocol绕过Cloudflare，实现高效数据抓取。若API数据不完整，则回退至页面抓取。
-   **Ave.ai**: 作为第二数据源，提供额外或补充的代币数据，尤其在gmgn.ai数据缺失时。

### 3. 智能AI评分与风险分析
-   **早期得分 (Early Score)**: 对代币的潜在表现进行评分（1-10分），综合考虑流动性、市值、持有人数量、交易量、社交媒体等多个维度。
-   **风险评估 (Risk)**: 识别潜在风险，如流动性不足、持仓集中度过高、Bundler活动异常、税率偏高、蜜罐等。
-   **Why Alpha 分析**: 提供基于AI的代币核心价值主张（Alpha）分析，解释其高潜力或高风险的原因。
-   **Narrative Vibe**: 识别代币所属的叙事类别（如动物币、政治名人币、AI概念等）。

### 4. 格式化输出
-   将代币分析结果格式化为清晰易读的消息，包含关键指标表格、AI评分、风险提示、Twitter/Website链接等，直接发送给用户。

## 使用说明

### 如何使用
-   **直接提供合约地址**: 用户可以直接发送合约地址给Agent，Agent将自动调用此技能进行分析。
    *   例如: `分析代币 0x123...abc`
    *   例如: `给我看看这个合约的分析 0xabc...123`
-   **指定链和合约地址**: 如果用户知道代币所属的链，可以明确指定，以加速查询。
    *   例如: `solana 链上的 123...abc 合约分析`
    *   例如: `bsc 代币 0xabc...123 的信息`

### 脚本资源

### `scripts/token_query.py`
-   **功能**: 技能的核心逻辑，负责通过gmgn.ai和Ave.ai查询代币数据，进行AI评分与风险分析，并格式化最终的通知消息。
-   **使用**: 该脚本由OpenClaw自动调用，其输出将被捕获并由Agent发送给用户。

---

**请注意：**
-   确保 `token_query.py` 脚本及其所有依赖项（如 `aiohttp`）在OpenClaw环境中可用。
-   查询需要连接到本地运行的Chrome DevTools Protocol (ws://localhost:9222)，请确保Chrome已正确配置并运行。