# University & Immigration Targets

## University Score Requirements

### General Guidelines
| Program Type | Typical Minimum |
|--------------|-----------------|
| Top 20 US MBA | 100+ |
| Top 50 US Graduate | 90-100 |
| Most US Undergrad | 80-90 |
| UK Universities | 90-100 (Russell Group) |
| Canadian Universities | 86-100 |

### MyBest Score Acceptance

**Accept MyBest scores:**
- Yale School of Management
- NYU Stern
- Some state universities

**Require single-sitting:**
- MIT
- Stanford Graduate School of Business
- Most PhD programs

**Always verify current policy** — Requirements change frequently.

### Section Minimums
Some programs require minimum scores per section:
- Speaking minimum: Common for TA-ship positions
- Writing minimum: Common for research programs
- Examples:
  - Berkeley EECS: Speaking 26
  - Columbia Business: No minimum but "24+ preferred per section"

## Immigration Requirements

### United States
| Visa/Status | TOEFL Requirement |
|-------------|-------------------|
| H1B | Not required (employer decides) |
| EB-1, EB-2 | Not required (some cases benefit from it) |
| Student Visa (F-1) | Required by university, not visa |

### Canada
| Program | TOEFL Requirement |
|---------|-------------------|
| Express Entry | Not accepted (use IELTS or CELPIP) |
| Provincial Nominee | Varies by province |
| Student Visa | University-dependent |

**Note:** Canada immigration strongly prefers IELTS/CELPIP over TOEFL.

### United Kingdom
| Purpose | Accepted |
|---------|----------|
| Student Visa | Yes (if university accepts) |
| Skilled Worker | IELTS/PTE preferred, some accept TOEFL |

### Australia
| Purpose | Accepted |
|---------|----------|
| Student Visa | Yes (79+ overall for most) |
| Skilled Migration | Points-based; IELTS/PTE more common |

## Score Sending Strategy

### Timeline
- Scores available: 4-8 days after test
- Score delivery: 6-10 business days
- Plan test date: At least 4 weeks before application deadline

### Cost Optimization
- 4 free score sends if selected on test day
- Additional reports: $20 each
- Score sends are per-university, not per-program

### What to Send
| Application Type | What to Send |
|------------------|--------------|
| US Graduate | Official ETS score send required |
| US Undergrad | Often self-reported initially, official later |
| UK/Canada | Varies — check each university |

## Waivers & Alternatives

### TOEFL Waiver Eligibility (Common Criteria)
- Native English speaker
- Completed degree in English-speaking country
- Studied X years in English-medium school
- Citizen of English-speaking country

**Always apply for waiver if eligible** — saves $200+ and stress.

### Alternative Tests
| Test | Common Acceptance |
|------|-------------------|
| IELTS | Very wide — sometimes more than TOEFL |
| Duolingo English Test | Growing acceptance, cheaper |
| PTE Academic | Popular for Australia/UK immigration |
| Cambridge (C1/C2) | Less common for US, good for Europe |

### Score Equivalency (Approximate)
| TOEFL iBT | IELTS | Duolingo |
|-----------|-------|----------|
| 120 | 9.0 | 160 |
| 110 | 8.0 | 145 |
| 100 | 7.0 | 125 |
| 90 | 6.5 | 110 |
| 80 | 6.0 | 100 |

## Decision Framework

### Should I Retake?
```
If target_score - current_score > 5:
    Definitely retake (if time permits)
    
If target_score - current_score <= 3:
    Consider: Can other application components compensate?
    
If current_score > target_score:
    Don't retake unless aiming for scholarships
```

### Which Test to Take?
```
If target = US universities only:
    TOEFL iBT (most accepted)
    
If target = UK/Australia/Canada immigration:
    IELTS (more accepted for visas)
    
If target = multiple countries/purposes:
    Check overlap, might need both
    
If budget-constrained:
    Duolingo ($59 vs $200+)
```
