# Study Methods

## Daily Schedule Templates

### Full-Time Student (3+ hours/day)
| Time Block | Activity |
|------------|----------|
| Morning (1h) | Reading or Listening practice |
| Afternoon (1h) | Speaking tasks + recording review |
| Evening (1h) | Writing practice + vocabulary |

### Working Professional (1-1.5 hours/day)
| Time Block | Activity |
|------------|----------|
| Commute | Vocabulary app / Listening clips |
| Lunch (30min) | One section practice |
| Evening (30min) | Speaking or Writing task |

### Weekend Intensive
| Time Block | Activity |
|------------|----------|
| Morning (2h) | Full Reading + Listening section |
| Afternoon (2h) | Speaking all 4 tasks + Writing both tasks |
| Evening (1h) | Review errors + plan next week |

## Section-Specific Strategies

### Reading
1. **Skim first** — Read intro, first sentence of each paragraph, conclusion (2 min)
2. **Question-driven** — Read questions before deep-reading passage
3. **Time budget** — 17-18 min per passage, not 20
4. **Prose summary** — Eliminate details, keep main ideas only
5. **Insert text** — Look for transition words and referents

### Listening
1. **Active note-taking** — Main ideas, examples, transitions
2. **Don't write everything** — Keywords and relationships
3. **Predict questions** — Intro = main idea Q, examples = detail Q
4. **Stay focused during lectures** — 5-6 minutes is a long time
5. **Attitude questions** — Listen for tone words and hedging

### Speaking
| Task | Key Strategy |
|------|--------------|
| Task 1 | Clear opinion + 2 reasons with examples |
| Task 2 | Summarize reading point + lecture response |
| Task 3 | Summarize campus situation + student's preference |
| Task 4 | Summarize academic concept + examples from lecture |

**Universal speaking tips:**
- Speak clearly, not fast
- Use transitions: "First," "However," "For example"
- Don't memorize — it sounds robotic
- Record and listen to yourself daily

### Writing

**Integrated Task (20 min):**
1. Read passage carefully (3 min)
2. Take notes during lecture
3. Write response showing how lecture relates to/challenges reading
4. Structure: Intro → Point 1 → Point 2 → Point 3
5. Target: 250-300 words

**Academic Discussion (10 min):**
1. Read professor's question and student responses (1 min)
2. Take a clear position
3. Add new point OR disagree with nuance
4. Target: 100-150 words

## Practice Resources

### Official (Most Accurate)
- ETS TOEFL Practice Online (TPO) — Paid, most realistic
- Free Practice Test from ETS — One free test
- Official TOEFL iBT Prep Course — EdX/Coursera

### Supplementary
- Academic word lists (AWL) — Vocabulary building
- TED Talks — Listening practice (lecture style)
- Scientific American / The Economist — Reading practice
- Speaking recordings — Self-review

## Error Analysis Method

### 1. Categorize Error Type
| Type | Description | Fix |
|------|-------------|-----|
| **Content** | Didn't understand material | More exposure to topic |
| **Question** | Misread what was asked | Practice question types |
| **Time** | Rushed or ran out | Practice pacing |
| **Careless** | Knew but made mistake | Slow down, verify |
| **Vocabulary** | Didn't know key word | Build academic vocab |

### 2. Error Tracking
For each error, log:
- Section and question type
- Why you got it wrong (the actual reason)
- What you'll do differently
- Review date

### 3. Spaced Review
Wrong questions return for review:
- Day 3: Same question type, different content
- Day 7: Similar difficulty
- Day 14: Mixed practice including this type

## Score Improvement Prioritization

### Where to Focus First
| Current Score | Focus Area |
|---------------|------------|
| Below 80 | Basics in all sections — vocabulary, comprehension |
| 80-95 | Identify weakest 2 sections, intensive practice |
| 95-105 | Fine-tune weakest question types, polish speaking fluency |
| 105+ | Perfect weak spots, maintain strong sections |

### ROI by Section
- **Reading** — Easiest to improve, most predictable
- **Listening** — Moderate, requires consistent practice
- **Writing** — Learnable structure, grammar can be improved
- **Speaking** — Hardest for many, requires active practice

## Mock Test Protocol

### Frequency
- Full mock test: Every 2 weeks
- Section practice: Daily
- Question type drills: 2-3x per weak type per week

### After Each Mock
1. Score immediately
2. Review all errors same day
3. Categorize error types
4. Update weak area priorities in ~/toefl/sections/
5. Adjust study plan if needed
