# Feedback & Self-Improvement System

## Feedback Loop

### Track What Works
```markdown
## Effective Strategies
- Speaking: Recording self and listening back improved fluency
- Writing: Using specific academic transitions (furthermore, conversely)
- Reading: Skimming first then question-driven reading
- Listening: Note-taking with symbols, not full words
```

### Track What Doesn't Work
```markdown
## Ineffective Approaches
- Speaking: Memorized templates sounded robotic, scored low
- Writing: Trying to use "impressive" vocabulary I don't control
- Listening: Trying to write everything (miss the audio)
```

### Patterns to Update
```markdown
## Evolving Insights
- Academic Discussion: Shorter, clearer responses score better than long rambling
- Speaking Task 4: Missing third example is worse than brief third example
- Reading: Vocabulary questions are free points, don't overthink
```

## User Corrections

When human overrides agent advice, log:
```markdown
## Corrections Log
- [02-13] Suggested full practice test, user said they needed targeted Speaking only → respect limited time
- [02-10] Recommended 2 weeks more prep, user said deadline is firm → adjust strategy to maximize with constraints
```

## Score Prediction Calibration

### Track Predictions vs Actual
```markdown
## Prediction Accuracy
| Date | Predicted | Actual | Difference |
|------|-----------|--------|------------|
| 02-01 | 95 | 92 | -3 |
| 02-15 | 98 | 99 | +1 |
```

Adjust future predictions based on consistent over/under estimation.

## Resource Effectiveness

### Track Which Materials Help
```markdown
## Resource Ratings
| Resource | Section | Effectiveness | Notes |
|----------|---------|---------------|-------|
| TPO 50-60 | All | ★★★★★ | Most realistic |
| TED Talks | Listening | ★★★★ | Good but easier than test |
| ETS Writing Guide | Writing | ★★★★★ | Official rubrics helpful |
| Random YouTube | Speaking | ★★ | Quality varies wildly |
```

## Timing Optimization

### Session Length Effectiveness
```markdown
## Study Session Analysis
- 30 min sessions: Good for single section focus
- 60 min sessions: Optimal for full section practice
- 90+ min sessions: Diminishing returns, fatigue sets in
- Best time of day: Morning (user-specific)
```

## Progress Stalls

### Plateau Detection
If score hasn't improved in 2+ weeks:
1. Check if practicing is targeted (not random)
2. Verify error analysis is being done
3. Look for unaddressed weak areas
4. Consider technique change, not more volume

### Breaking Plateaus
```markdown
## Plateau Interventions
- Speaking plateau at 22: Switched from scripted to conversational style → 25
- Writing plateau at 20: Focused on organization over vocabulary → 24
- Listening plateau at 24: Practiced at 1.25x speed → 27
```

## Exam Day Insights

### Pre-Test Routine
```markdown
## What Worked
- Light review night before, not cramming
- Good sleep (7+ hours)
- Arrived 30 min early
- Skipped coffee (too jittery)
```

### Post-Test Reflection
```markdown
## Exam Day Notes
- Testing center was cold — bring layers
- Headphones were uncomfortable — practice with similar
- Break was short — use bathroom efficiently
- Speaking section felt weird with others talking nearby
```
