---
name: todoist
description: Integrate with Todoist task management using natural language. Use when the user wants to manage Todoist tasks or projects through conversational commands like "show my tasks for today", "add 'call dentist' to my todo list", "complete my task about the meeting", or any mention of Todoist, tasks, due dates, or project management.
credentials:
  - name: TODOIST_API_KEY
    description: Todoist API token from https://todoist.com/app/settings/integrations/developer
    required: true
    sensitive: true
---

# Todoist Skill — Natural Language Task Management

Manage your Todoist tasks conversationally. No need to remember CLI syntax — just talk naturally about your tasks.

## Natural Language Examples

This skill understands conversational requests:

**List tasks:**
- "What tasks do I have today?"
- "Show me my Todoist list for this week"
- "What do I have overdue?"
- "Show priority 1 tasks"

**Add tasks:**
- "Add 'buy milk' to my todo list"
- "Create a task to call the dentist tomorrow"
- "I need to review the Q4 report by Friday"
- "Add 'weekly standup' due every Monday"

**Complete tasks:**
- "Complete my task about the dentist"
- "Mark the milk task as done"
- "I finished the report"

**Manage projects:**
- "What projects do I have in Todoist?"
- "Show tasks from my Work project"

## Prerequisites

- `TODOIST_API_KEY` environment variable must be set with your Todoist API token
- Get your token at: https://todoist.com/app/settings/integrations/developer

## Technical Usage

If you prefer CLI commands or need to script operations, use the Python script directly:

```bash
# List today's tasks
python3 todoist/scripts/todoist.py list --filter "today"

# Add a task
python3 todoist/scripts/todoist.py add "Buy milk" --due "tomorrow" --priority 2

# Complete a task by ID
python3 todoist/scripts/todoist.py complete "TASK_ID"

# List all projects
python3 todoist/scripts/todoist.py projects
```

## Filter Syntax

When filtering tasks (via natural language or CLI):

- `today` — tasks due today
- `overdue` — overdue tasks
- `tomorrow` — tasks due tomorrow
- `p1`, `p2`, `p3`, `p4` — priority filters
- `7 days` — tasks due in next 7 days
- `@label` — tasks with specific label
- `#project` — tasks in project
- Combine with `&` (and) and `|` (or): `today & p1`

## Priority Levels

- `1` — Urgent (red)
- `2` — High (orange)
- `3` — Medium (blue)
- `4` — Low (white/gray, default)

## Features

- ✅ Natural language task management
- ✅ Timezone-aware "today" filtering
- ✅ Smart filtering (excludes completed tasks)
- ✅ Recurring task support
- ✅ Full Todoist API v1 coverage

## Response Format

The script outputs JSON for programmatic use. See `references/api.md` for full API documentation.

## Notes

- The skill automatically filters out completed tasks
- "Today" uses your local timezone (set `TZ` environment variable if needed)
- Natural language dates ("tomorrow", "next Friday") use Todoist's built-in parsing
