# Todoist Skill for OpenClaw

Manage your Todoist tasks directly from OpenClaw. Add tasks, check your list, complete items — all through natural language or CLI commands.

## Features

- ✅ List tasks with filters (today, overdue, by project, by priority)
- ✅ Add new tasks with natural language due dates
- ✅ Complete tasks
- ✅ List all projects
- ✅ Full timezone support (respects your local time)
- ✅ Smart filtering — "today" actually shows today's tasks, not future recurring ones

## Prerequisites

1. **Todoist API Token**
   - Go to https://todoist.com/app/settings/integrations/developer
   - Copy your API token
   - Set it as an environment variable:
     ```bash
     export TODOIST_API_KEY="your_token_here"
     ```

2. **OpenClaw** (if using as a skill)
   - OpenClaw must be installed and running

## Installation

### Option A: Install as OpenClaw Skill (Recommended)

1. Download the latest `.skill` file from [Releases](../../releases)

2. Install to OpenClaw:
   ```bash
   # Copy to OpenClaw skills directory
   sudo cp todoist.skill /usr/lib/node_modules/openclaw/skills/
   
   # Or unzip manually
   sudo unzip todoist.skill -d /usr/lib/node_modules/openclaw/skills/
   ```

3. Restart OpenClaw

4. Done! Now you can say things like:
   - "Show me my tasks for today"
   - "Add 'call dentist' to my todo list for tomorrow"
   - "Complete my task about the meeting"

### Option B: Standalone CLI

If you just want the Python script without OpenClaw integration:

1. Clone this repo:
   ```bash
   git clone https://github.com/YOUR_USERNAME/openclaw-skill-todoist.git
   cd openclaw-skill-todoist
   ```

2. Make sure `TODOIST_API_KEY` is set in your environment

3. Run directly:
   ```bash
   python3 scripts/todoist.py list --filter today
   ```

## Usage

### Natural Language (with OpenClaw)

Once installed, just talk to OpenClaw naturally:

| What you say | What happens |
|-------------|--------------|
| "What tasks do I have today?" | Lists today's open tasks |
| "Add 'buy milk' to my todo list" | Creates task in Inbox |
| "Add 'review PR' due tomorrow priority 2" | Creates task with due date and priority |
| "Complete my task about the dentist" | Completes the matching task |
| "Show my Todoist projects" | Lists all your projects |

### CLI Commands

If running the script directly:

```bash
# List tasks
python3 scripts/todoist.py list
python3 scripts/todoist.py list --filter "today"
python3 scripts/todoist.py list --filter "overdue"
python3 scripts/todoist.py list --project "PROJECT_ID" --limit 10

# Add a task
python3 scripts/todoist.py add "Buy milk"
python3 scripts/todoist.py add "Review PR" --due "tomorrow" --priority 2
python3 scripts/todoist.py add "Weekly report" --due "every Friday"

# Complete a task
python3 scripts/todoist.py complete "TASK_ID"

# List projects
python3 scripts/todoist.py projects
```

### Filter Syntax

When listing tasks, you can use Todoist's powerful filter syntax:

- `today` — Tasks due today
- `tomorrow` — Tasks due tomorrow
- `overdue` — Overdue tasks
- `p1`, `p2`, `p3`, `p4` — Priority filters
- `7 days` — Tasks due in next 7 days
- `@label` — Tasks with specific label
- `#project` — Tasks in project
- `today & p1` — Today's urgent tasks
- `overdue | today` — Overdue or today's tasks

### Priority Levels

- `1` — Urgent (red)
- `2` — High (orange)
- `3` — Medium (blue)
- `4` — Low (white/gray, default)

## Project Structure

```
todoist/
├── SKILL.md              # Instructions for OpenClaw AI
├── scripts/
│   └── todoist.py        # Main CLI script (Python 3)
└── references/
    └── api.md            # Full Todoist API reference
```

## Environment Variables

| Variable | Required | Description |
|----------|----------|-------------|
| `TODOIST_API_KEY` | Yes | Your Todoist API token |
| `TZ` | No | Your timezone (e.g., `America/Chicago`). Used for accurate "today" filtering |

## Troubleshooting

**"TODOIST_API_KEY environment variable not set"**
- Make sure you've exported the API key: `export TODOIST_API_KEY="..."`
- For persistent setup, add it to your `~/.bashrc` or `~/.zshrc`

**Tasks showing wrong date for "today"**
- Set your timezone: `export TZ="America/Chicago"` (or your timezone)

**Permission denied when running script**
- Make it executable: `chmod +x scripts/todoist.py`

## API Reference

See [references/api.md](references/api.md) for complete Todoist API v1 documentation.

Official docs: https://developer.todoist.com/api/v1/

## License

MIT — Do what you want with it.

## Contributing

This is a personal skill, but feel free to fork and modify for your own use.

---

Built for OpenClaw. Works anywhere Python 3 runs.
