import json

# A class for handling the to-do tasks dynamically
class ToDoManager:
    def __init__(self):
        self.tasks = []

    def add_task(self, title, description, priority="Medium"):
        task = {
            "title": title,
            "description": description,
            "priority": priority,
            "status": "pending"
        }
        self.tasks.append(task)
        return f"Task '{title}' has been added to your to-do list."

    def list_tasks(self):
        if not self.tasks:
            return "Your to-do list is empty."

        response = "Here is your to-do list:\n"
        for idx, task in enumerate(self.tasks, 1):
            response += f"{idx}. {task['title']} - {task['status'].capitalize()} (Priority: {task['priority']})\n"
        return response

    def update_task(self, index, status, new_description=None):
        if index <= 0 or index > len(self.tasks):
            return "Invalid task number. Please try again."
        
        self.tasks[index - 1]["status"] = status
        if new_description:
            self.tasks[index - 1]["description"] = new_description

        return f"Task {index} has been updated to status '{status}'."

    def clear_tasks(self):
        self.tasks = []
        return "Your to-do list has been cleared."

# Example usage
if __name__ == "__main__":
    todo = ToDoManager()

    # Adding tasks
    print(todo.add_task("Research target audience", "Understand key demographics", priority="High"))
    print(todo.add_task("Create marketing materials", "Design banners, write copy, etc.", priority="Medium"))

    # List tasks
    print(todo.list_tasks())

    # Update tasks
    print(todo.update_task(1, "completed"))

    # Final task list
    print(todo.list_tasks())

    # Clear tasks
    print(todo.clear_tasks())