# Notifications API

Base URL: `/api/v1/notifications`

Platform notifications for the authenticated user. Notifications are generated by system events such as new orders, deliveries, dispute updates, and review postings.

---

## GET /api/v1/notifications/

List notifications for the authenticated user.

**Auth:** Required

### Query Parameters

| Field | Type | Required | Description |
|---|---|---|---|
| `unread_only` | bool | No | If `true`, return only unread notifications. Default `false` |
| `offset` | int | No | Pagination offset. Default `0` |
| `limit` | int | No | Number of results. Default `20` |

### Request Example

```
GET /api/v1/notifications/?unread_only=true&offset=0&limit=10
Authorization: Bearer eyJhbGciOiJIUzI1NiIs...
```

### Response Example

```json
{
  "items": [
    {
      "id": "notif001-2233-4455-6677-8899aabbccdd",
      "user_id": "a1b2c3d4-e5f6-7890-abcd-ef1234567890",
      "type": "new_order",
      "title": "新订单",
      "title_en": "New Order",
      "message": "您收到了一个新的订单，金额为 $200.00 USD",
      "message_en": "You received a new order for $200.00 USD",
      "resource_type": "order",
      "resource_id": "11223344-5566-7788-99aa-bbccddeeff00",
      "is_read": false,
      "created_at": "2026-02-27T11:00:00Z"
    },
    {
      "id": "notif002-3344-5566-7788-99aabbccddee",
      "user_id": "a1b2c3d4-e5f6-7890-abcd-ef1234567890",
      "type": "review_received",
      "title": "收到新评价",
      "title_en": "New Review Received",
      "message": "个人对订单 #11223344 提交了5星评价",
      "message_en": "Personal submitted a 5-star review for order #11223344",
      "resource_type": "review",
      "resource_id": "ee112233-4455-6677-8899-aabbccddeeff",
      "is_read": false,
      "created_at": "2026-03-02T10:05:00Z"
    },
    {
      "id": "notif003-4455-6677-8899-aabbccddeeff",
      "user_id": "a1b2c3d4-e5f6-7890-abcd-ef1234567890",
      "type": "dispute_opened",
      "title": "纠纷已开启",
      "title_en": "Dispute Opened",
      "message": "订单 #22334455 的个人已开启纠纷",
      "message_en": "The personal user has opened a dispute for order #22334455",
      "resource_type": "dispute",
      "resource_id": "99887766-5544-3322-1100-ffeeddccbbaa",
      "is_read": false,
      "created_at": "2026-03-05T14:00:00Z"
    }
  ],
  "total": 3
}
```

### Errors

| Status | Code | Description |
|---|---|---|
| 401 | `not_authenticated` | Missing or invalid access token |

---

## GET /api/v1/notifications/unread-count

Get the total count of unread notifications for the authenticated user.

**Auth:** Required

### Request Body

None.

### Request Example

```
GET /api/v1/notifications/unread-count
Authorization: Bearer eyJhbGciOiJIUzI1NiIs...
```

### Response Example

```json
{
  "unread_count": 3
}
```

### Errors

| Status | Code | Description |
|---|---|---|
| 401 | `not_authenticated` | Missing or invalid access token |

---

## POST /api/v1/notifications/{notification_id}/read

Mark a specific notification as read.

**Auth:** Required

### Path Parameters

| Field | Type | Required | Description |
|---|---|---|---|
| `notification_id` | UUID | Yes | Notification ID |

### Request Body

None.

### Request Example

```
POST /api/v1/notifications/notif001-2233-4455-6677-8899aabbccdd/read
Authorization: Bearer eyJhbGciOiJIUzI1NiIs...
```

### Response Example

```json
{
  "id": "notif001-2233-4455-6677-8899aabbccdd",
  "user_id": "a1b2c3d4-e5f6-7890-abcd-ef1234567890",
  "type": "new_order",
  "title": "新订单",
  "title_en": "New Order",
  "message": "您收到了一个新的订单，金额为 $200.00 USD",
  "message_en": "You received a new order for $200.00 USD",
  "resource_type": "order",
  "resource_id": "11223344-5566-7788-99aa-bbccddeeff00",
  "is_read": true,
  "created_at": "2026-02-27T11:00:00Z"
}
```

### Errors

| Status | Code | Description |
|---|---|---|
| 401 | `not_authenticated` | Missing or invalid access token |
| 404 | `notification_not_found` | No notification with this ID or it belongs to another user |

---

## POST /api/v1/notifications/read-all

Mark all notifications as read for the authenticated user.

**Auth:** Required

### Request Body

None.

### Request Example

```
POST /api/v1/notifications/read-all
Authorization: Bearer eyJhbGciOiJIUzI1NiIs...
```

### Response Example

```json
{
  "message": "All notifications marked as read",
  "marked_count": 3
}
```

### Errors

| Status | Code | Description |
|---|---|---|
| 401 | `not_authenticated` | Missing or invalid access token |
