#!/bin/bash
# pipeline-report.sh - Generate sales pipeline reports
# Usage: ./pipeline-report.sh [command]

SALES_DIR="${HOME}/.openclaw/workspace/sales"
REPORTS_DIR="$SALES_DIR/analytics"
mkdir -p "$REPORTS_DIR"

generate_weekly() {
    local date=$(date +%Y-%m-%d)
    local report_file="${REPORTS_DIR}/weekly-${date}.md"
    
    cat > "$report_file" << EOF
# Sales Report — Week of ${date}

## Summary
- New leads: 
- Deals advanced: 
- Deals closed won: 
- Deals closed lost: 

## Pipeline Health
- Total pipeline: \$
- Change from last week: 
- Weighted pipeline: \$
- Forecast this month: \$

## Activity Metrics
- Outreach sent: 
- Meetings held: 
- Proposals sent: 
- Follow-ups completed: 

## Wins
| Company | Value | Time to Close | Key Factor |
|---------|-------|---------------|------------|

## Losses
| Company | Value | Stage Lost | Reason |
|---------|-------|------------|--------|

## Stale Deals (>14 days no activity)
| Company | Stage | Days Stale | Action Needed |
|---------|-------|------------|---------------|

## Focus for Next Week
1. 
2. 
3. 

---
*Report generated by pipeline-report.sh*
EOF
    
    echo "✅ Weekly sales report created: $report_file"
}

generate_forecast() {
    local date=$(date +%Y-%m-%d)
    local report_file="${REPORTS_DIR}/forecast-${date}.md"
    
    cat > "$report_file" << EOF
# Sales Forecast — ${date}

## This Month
- Committed (90%+): \$
- Best case (50%+): \$
- Pipeline (all): \$
- Target: \$
- Gap: \$

## By Stage (This Month Expected Closes)

| Stage | # Deals | Value | Probability | Weighted |
|-------|---------|-------|-------------|----------|
| Qualified | | \$ | 20% | \$ |
| Demo | | \$ | 40% | \$ |
| Proposal | | \$ | 60% | \$ |
| Negotiation | | \$ | 80% | \$ |
| **Total** | | \$ | | \$ |

## Deals Expected to Close

| Company | Value | Stage | Close Date | Confidence |
|---------|-------|-------|------------|------------|

## Risks
- 

## Upside Opportunities
- 

---
*Forecast generated by pipeline-report.sh*
EOF
    
    echo "✅ Sales forecast created: $report_file"
}

case "$1" in
    weekly)
        generate_weekly
        ;;
    
    forecast)
        generate_forecast
        ;;
    
    list)
        echo "📊 Available Reports"
        echo "==================="
        ls "$REPORTS_DIR"/*.md 2>/dev/null || echo "No reports yet."
        ;;
    
    *)
        echo "Sales Pipeline Report Generator"
        echo "================================"
        echo "Commands:"
        echo "  weekly    - Generate weekly sales report"
        echo "  forecast  - Generate sales forecast"
        echo "  list      - List all reports"
        ;;
esac
