# Common Time Traps — Reference

## Planning Traps

### The Planning Fallacy
**Trap:** Underestimating how long tasks take.

**Why it happens:** We imagine best-case scenarios.

**Fix:** 
- Track actual time for a week
- Multiply estimates by 1.5
- Add buffer blocks

### The Infinite To-Do List
**Trap:** List keeps growing. Never feels "done."

**Why it happens:** Adding is easier than completing or deleting.

**Fix:**
- Daily: max 9 tasks (1-3-5 rule)
- Weekly: max 3 priorities
- Delete ruthlessly

### Planning Without Blocking
**Trap:** "I'll do it tomorrow" but tomorrow has no slot.

**Why it happens:** To-do list ≠ calendar.

**Fix:** If it's not on the calendar, it doesn't exist. Block time.

## Execution Traps

### Morning Email
**Trap:** Start day in reactive mode.

**Why it happens:** Email feels productive. It's not.

**Fix:** Deep work first. Email at 11am.

### The "Quick Check"
**Trap:** "Let me just check [email/Slack/Twitter]..."

**Why it happens:** Dopamine. Habit.

**Fix:** 
- Phone in another room
- Website blockers during deep work
- Scheduled check times only

### Context Switching
**Trap:** Jumping between tasks constantly.

**Why it happens:** Everything feels urgent.

**Cost:** 23 minutes to refocus after interruption.

**Fix:** 
- Batch similar tasks
- Single-task deep work blocks
- "Office hours" for interruptions

### The Meeting That Could Be Email
**Trap:** Accepting every meeting invite.

**Why it happens:** Social pressure. FOMO.

**Fix:**
- Default to decline
- Ask: "What's the decision we need to make?"
- Suggest async alternatives

## Energy Traps

### Ignoring Energy Levels
**Trap:** Hard work when tired. Easy work when sharp.

**Why it happens:** Calendar-driven, not energy-driven.

**Fix:** Match task difficulty to energy:
- Peak hours → Deep work
- Low hours → Admin, email

### No Breaks
**Trap:** Working straight through.

**Why it happens:** "I'll rest when I'm done."

**Cost:** Diminishing returns. Burnout.

**Fix:** 
- 50-10 or 90-20 work-break rhythm
- Lunch away from desk
- End time is end time

### Sleep Sacrifice
**Trap:** "I'll sleep less to get more done."

**Reality:** 6 hours of sleep = 2 drinks of cognitive impairment.

**Fix:** Protect 7-8 hours. Non-negotiable.

## Commitment Traps

### The Yes Default
**Trap:** Saying yes to everything.

**Why it happens:** Wanting to help. Fear of missing out.

**Fix:** 
- Default to "let me check my calendar"
- Ask: "What will I NOT do to make time for this?"
- Practice: "I can't commit to that right now"

### Sunk Cost Continuation
**Trap:** Finishing things you've started, even when wrong.

**Why it happens:** "I've already invested X hours..."

**Fix:** 
- Past time is gone
- Only future value matters
- Quitting is a skill

### Perfectionism
**Trap:** Polishing instead of finishing.

**Why it happens:** Fear of judgment. "Not ready."

**Fix:**
- Good enough → ship
- Feedback > polish
- Deadlines force done

## The Meta-Trap

### Optimizing the System
**Trap:** Endless tweaking of productivity systems.

**Why it happens:** Feels productive. Avoids real work.

**Fix:**
- Pick one system
- Use it for 30 days
- Then evaluate
- Tweaking ≠ working
