# Time Blocking — Reference

## What It Is

Assigning specific hours to specific tasks. Not a to-do list — a schedule.

## Why It Works

- Eliminates "what should I do now?" decisions
- Creates artificial deadlines (Parkinson's Law)
- Makes overcommitment visible (can't fit 12 hours into 8)
- Protects important work from urgent interruptions

## The Method

### Step 1: Identify Your MITs
Most Important Tasks — max 3 per day.

Ask: "If I only finish ONE thing today, what must it be?"

### Step 2: Assign Time Blocks

| Block Type | Duration | Purpose |
|------------|----------|---------|
| Deep work | 90-180 min | Creative, complex, high-value |
| Shallow work | 30-60 min | Email, admin, routine |
| Meetings | As needed | Collaboration, calls |
| Buffer | 15-30 min | Transitions, overflow |

### Step 3: Protect the First Block

The first deep work block is sacred:
- No meetings before it ends
- No email before it ends
- No "quick questions" before it ends

### Step 4: Add Buffers

Between every block: 15-30 minutes.

Why:
- Meetings run over
- Tasks take longer than expected
- Bathroom, coffee, mental reset

Without buffers, one delay cascades through your entire day.

## Example Day

```
08:00-08:30 — Morning routine (not work)
08:30-10:30 — Deep work: [MIT #1]
10:30-11:00 — Buffer + email check
11:00-12:00 — Deep work: [MIT #2]
12:00-13:00 — Lunch (protected)
13:00-14:00 — Meeting block
14:00-14:15 — Buffer
14:15-15:15 — Meeting block
15:15-15:30 — Buffer + email
15:30-16:30 — Shallow work / MIT #3
16:30-17:00 — Plan tomorrow
```

## Common Mistakes

| Mistake | Fix |
|---------|-----|
| Blocks too short | Minimum 90 min for deep work |
| No buffers | Add 15-30 min between every block |
| First block is email | Deep work first, always |
| Overscheduling | Leave 20% unscheduled |
| Not planning the night before | 5 min tonight saves 30 min tomorrow |

## When to Flex

Time blocking isn't rigid. Flex when:
- Genuine emergency (not "urgent" email)
- You're in flow and want to extend deep work
- A block finishes early — take the buffer or start next

Don't flex for:
- "Quick questions" (they're never quick)
- Notifications
- Feeling like checking email
