# Prioritization Frameworks — Reference

## The Problem

Too many tasks. Not enough time. Everything feels urgent.

Solution: systematic prioritization, not gut feeling.

## Framework 1: Eisenhower Matrix

| | Urgent | Not Urgent |
|---|--------|------------|
| **Important** | DO NOW | SCHEDULE |
| **Not Important** | DELEGATE | DELETE |

### How to Use

1. List all tasks
2. For each: Is it important? Is it urgent?
3. Place in quadrant
4. Work quadrants in order: DO → SCHEDULE → DELEGATE → DELETE

### The Trap

Most people live in "Urgent" columns. Important-Not-Urgent gets ignored.

**Fix:** Schedule Important-Not-Urgent FIRST, before urgent stuff fills your day.

## Framework 2: MIT (Most Important Tasks)

Pick 3 tasks that MUST happen today. Everything else is bonus.

### Rules

- Exactly 3 (not 5, not 7)
- Specific and completable (not "work on project")
- At least 1 important-not-urgent
- Written down before starting work

### Example

❌ Bad MITs:
- Work on presentation
- Emails
- Various meetings

✅ Good MITs:
- Finish slides 1-10 of presentation
- Send proposal to client X
- Complete code review for feature Y

## Framework 3: 1-3-5 Rule

Each day, plan:
- 1 big task
- 3 medium tasks
- 5 small tasks

Total: 9 tasks max.

### Why It Works

- Forces realistic planning
- Acknowledges task sizes differ
- Prevents overcommitment

## Framework 4: Time-Based Priority

When task has no clear deadline:

| If task takes... | Do it... |
|------------------|----------|
| < 2 minutes | Now |
| 2-30 minutes | Today's shallow work block |
| 30+ minutes | Schedule as deep work block |

## Framework 5: Warren Buffett 25-5

For life/career priorities (not daily):

1. List 25 goals
2. Circle top 5
3. The other 20 = your "avoid at all costs" list

### Why the Other 20 Are Dangerous

They're attractive enough to distract but not important enough to prioritize. They steal time from your real priorities.

## Which Framework to Use

| Situation | Framework |
|-----------|-----------|
| Overwhelmed by tasks | Eisenhower Matrix |
| Planning tomorrow | MIT (3 tasks) |
| Planning the week | 1-3-5 Rule |
| Quick decisions | 2-Minute Rule |
| Life direction | 25-5 Rule |

## The Meta-Rule

Any system beats no system.

Pick one. Use it for a week. Adjust. The perfect system doesn't exist — the one you actually use does.
