# Memory Template — Time Management

Create `~/time-management/memory.md` with this structure:

```markdown
# Time Management Memory

## Status
status: ongoing
version: 1.0.0
last: YYYY-MM-DD
integration: pending

## Energy Pattern
<!-- When they're most focused -->
peak-hours: 
low-energy: 
preferred-deep-work: 

## Constraints
<!-- Things they can't control -->
meeting-control: full | partial | none
fixed-commitments: 
no-meeting-zones: 

## Preferences
<!-- How they like to work -->
planning-time: evening | morning
review-day: 
block-duration: 
buffer-preference: 

## Current Focus
<!-- This week's priorities -->
mit-1: 
mit-2: 
mit-3: 

## Notes
<!-- Information the user has shared -->

---
*Updated: YYYY-MM-DD*
```

## Status Values

| Value | Meaning | Behavior |
|-------|---------|----------|
| `ongoing` | Still learning | Ask questions when relevant |
| `complete` | Has enough context | Work normally |
| `paused` | User said "not now" | Don't ask, work with what you have |

## Key Principles

- **No config keys visible** — use natural language in conversation
- **Learn from conversations** — note what the user shares about their patterns
- **Update `last`** on each use
- **Current Focus** changes weekly — update during reviews
