---
name: time-management
description: Manage time effectively as a solopreneur to maximize productivity and avoid burnout. Use when struggling with focus, feeling overwhelmed, context-switching too much, or wanting to optimize daily routines. Covers time-blocking, deep work, energy management, distraction elimination, and sustainable productivity systems. Trigger on "time management", "productivity", "focus", "get more done", "manage my time", "deep work", "avoid burnout", "daily routine".
---

# Time Management

## Overview
As a solopreneur, you wear every hat — product, sales, marketing, ops, finance. Without deliberate time management, you'll stay busy but make little progress. This playbook shows you how to structure your time to maximize high-value work, protect deep focus, and prevent burnout.

---

## Step 1: Understand Your Time Reality

Before optimizing, understand where your time actually goes.

**Time audit (do this for 1 week):**
1. Track every hour of your day in 1-hour blocks
2. Categorize each hour:
   - **Deep work** (focused, high-value tasks: product development, strategic planning, content creation)
   - **Shallow work** (admin, email, meetings, low-complexity tasks)
   - **Revenue-generating** (sales calls, customer work, marketing)
   - **Maintenance** (support, bug fixes, operational tasks)
   - **Wasted time** (social media scrolling, unnecessary meetings, distractions)

3. Calculate percentages per category

**Healthy solopreneur distribution (target):**
- Deep work: 30-40%
- Shallow work: 20-30%
- Revenue-generating: 20-30%
- Maintenance: 10-20%
- Wasted time: <5%

**Reality check:** Most solopreneurs spend 50%+ on shallow/maintenance work and <20% on deep work. This is why progress feels slow.

**Action:** Identify what's eating your time. Then ruthlessly cut, delegate, or automate low-value activities.

---

## Step 2: Time-Block Your Calendar

Time-blocking is the single highest-leverage time management technique. If it's not on your calendar, it won't happen.

**How to time-block:**

### Step 1: Block recurring time first (the non-negotiables)
- Deep work blocks (3-4 hours, 3-5 days/week)
- Exercise / health (30-60 min daily)
- Meals and breaks
- Sleep (yes, block sleep — protect it)

### Step 2: Block themed work blocks
Instead of scattered tasks, group similar work into blocks:
- **Admin block** (Monday 1-2pm): Email, invoicing, expense tracking
- **Content creation block** (Tuesday 9am-12pm): Write blog posts, social content
- **Customer work block** (Wednesday 9am-12pm, Friday 2-5pm): Client calls, deliverables
- **Business development block** (Thursday 9am-11am): Outreach, proposals, sales calls

### Step 3: Leave buffer time (20-30% of calendar)
Don't pack every hour. Leave white space for:
- Unexpected urgent tasks
- Overflow from blocks that run long
- Mental recovery between deep work sessions

**Sample time-blocked week:**
```
Monday:
  9-12pm: Deep work (product development)
  1-2pm: Admin block
  2-4pm: Shallow work / email / small tasks

Tuesday:
  9-12pm: Deep work (content creation)
  2-3pm: Business development calls

Wednesday:
  9-12pm: Customer work
  1-2pm: Meetings

Thursday:
  9-12pm: Deep work (strategic planning)
  2-4pm: Learning / skill development

Friday:
  9-12pm: Customer work
  1-3pm: Weekly review + next week planning
```

**Rule:** Schedule deep work during your peak energy hours (for most people: mornings). Shallow work goes in low-energy slots (afternoons, after lunch).

---

## Step 3: Protect Deep Work

Deep work (focused, uninterrupted time on cognitively demanding tasks) is where you create the most value. Protect it ruthlessly.

**Deep work rules:**

1. **Minimum 90-minute blocks.** Shorter blocks don't allow you to get into flow. Ideal: 2-4 hours.

2. **No interruptions.** During deep work:
   - Phone on airplane mode or Do Not Disturb
   - Close email, Slack, all messaging apps
   - Use website blocker (Freedom, Cold Turkey, Focus)
   - Put a sign on your door (if working at home with others)

3. **Single-task only.** Pick ONE task for the deep work block. No multitasking, no context-switching.

4. **Prepare in advance.** Before the block, know exactly what you're working on. Don't waste the first 30 minutes deciding.

5. **Take breaks between blocks.** After a deep work session, take 10-15 min break before the next one. Walk, stretch, snack — don't go straight to more focus work.

**Best tasks for deep work:**
- Writing (blog posts, proposals, documentation)
- Coding or product development
- Strategic planning or business analysis
- Creative work (design, video editing)
- Problem-solving or debugging

**Worst tasks for deep work (do these in shallow blocks):**
- Email
- Slack messages
- Scheduling meetings
- Expense tracking
- Social media posting

---

## Step 4: Manage Energy, Not Just Time

You have limited cognitive energy each day. Optimize for energy, not just hours worked.

**Energy management principles:**

### 1. Match task difficulty to energy level
- **High energy (morning for most):** Deep work, complex problem-solving, creative tasks
- **Medium energy (early afternoon):** Meetings, customer calls, collaborative work
- **Low energy (late afternoon):** Admin, email, shallow tasks

### 2. Take real breaks
- Every 90 minutes of work → 10-15 min break
- Every 4 hours of work → 30-60 min break (walk, exercise, eat)
- Breaks AWAY from screens (staring at your phone ≠ a break)

### 3. Protect sleep
7-8 hours non-negotiable. Sleep deprivation destroys productivity more than anything else. One all-nighter costs you 3 days of peak performance.

### 4. Move daily
30-60 min of exercise daily boosts energy, focus, and mood. Schedule it like a meeting.

### 5. Limit decision fatigue
Reduce trivial decisions:
- Wear the same type of outfit daily (fewer clothing decisions)
- Eat similar meals Mon-Fri (fewer food decisions)
- Use templates and systems (fewer process decisions)

**Rule:** You get ~4-6 hours of peak cognitive performance per day. Use them on your most important work. Everything else is maintenance.

---

## Step 5: Eliminate Distractions and Context-Switching

Every distraction or context-switch costs you 10-20 minutes of focus recovery time. Minimize them.

**Distraction elimination tactics:**

| Distraction | Solution |
|---|---|
| **Phone notifications** | Turn off all non-critical notifications. Use Do Not Disturb mode during deep work. |
| **Email checking every 5 min** | Check email 2-3x/day at scheduled times only (e.g., 11am, 3pm, 5pm). |
| **Slack / messaging** | Set status to "Focus mode" or "Do Not Disturb" during deep work. Batch-check messages 2-3x/day. |
| **Social media scrolling** | Use website blockers (Freedom, Cold Turkey). Delete apps from phone during work hours. |
| **Meetings interrupting deep work** | Block deep work time on calendar as "Busy" so meetings can't be scheduled over it. |
| **Open office / home distractions** | Noise-canceling headphones. Work from a coffee shop or library if home is too distracting. |

**Context-switching reduction:**
- Batch similar tasks (all emails in one block, all admin in one block)
- Don't hop between projects mid-day — finish one before starting another
- Use themed days if possible (Monday = product day, Tuesday = content day, etc.)

**Rule:** Every time you switch tasks, you lose 15 minutes. Batch ruthlessly.

---

## Step 6: Use the 80/20 Rule (Pareto Principle)

80% of your results come from 20% of your activities. Focus on the 20%.

**How to identify your 20%:**
1. List all your regular activities (product work, sales, marketing, support, admin, etc.)
2. For each, ask: "If I doubled time on this, would revenue or progress double?"
3. The activities where the answer is "yes" → your 20%
4. The activities where the answer is "no" → your 80% (minimize, delegate, or automate)

**Example:**
- Writing 1 high-quality blog post/week (20% activity) → drives SEO traffic for months
- Posting on 5 social platforms daily (80% activity) → scattered effort, low ROI

**Action:** Double down on your 20%. Cut or delegate everything else.

---

## Step 7: Weekly and Daily Planning Rituals

Structure prevents chaos. Plan weekly and daily to stay on track.

**Weekly planning (Sunday or Monday, 30 min):**
1. Review last week: What got done? What didn't? Why?
2. Set top 3 outcomes for this week (see goal-setting-okrs skill)
3. Time-block these priorities on your calendar
4. Identify 1-2 things to say no to or delegate this week

**Daily planning (every morning, 5-10 min):**
1. Review calendar for the day
2. Pick 1-3 most important tasks (MITs)
3. Time-block MITs first, before anything else
4. Identify potential distractions and plan how to avoid them

**End-of-day ritual (5 min):**
- Mark completed tasks
- Move incomplete tasks to tomorrow or later
- Note any blockers or wins
- Shut down completely (no "just checking email one more time")

**Rule:** Planning time is NOT wasted time. 15 minutes of planning saves 2+ hours of unfocused, reactive work.

---

## Step 8: Know When to Stop

Sustainable productivity requires rest. Overwork leads to burnout, which kills productivity far worse than taking time off.

**Burnout prevention strategies:**

1. **Set a hard stop time.** Example: "I stop working at 6pm every day, no exceptions."
2. **Take at least 1 full day off per week.** No email, no Slack, no "quick tasks."
3. **Take real vacations.** 1 week every quarter minimum. Fully disconnect.
4. **Monitor burnout signals:**
   - Constantly exhausted despite sleep
   - Decreased motivation or enthusiasm
   - Increased irritability or cynicism
   - Declining quality of work

If you see 2+ of these, you're burning out. Take a week off immediately.

**Rule:** You can't outwork burnout. Rest is productive.

---

## Time Management Mistakes to Avoid
- **No time-blocking.** Hoping to "find time" for important work never works. Block it or it won't happen.
- **Back-to-back meetings all day.** Leaves no time for actual work. Batch meetings into 1-2 blocks per week.
- **Checking email first thing in morning.** Email is other people's priorities. Do YOUR most important work first, then check email.
- **Working late into the night regularly.** Night work is low-quality work. Better to sleep and start fresh.
- **Not tracking where time goes.** You can't improve what you don't measure. Do a time audit quarterly.
- **Saying yes to everything.** Every yes is a no to something else. Protect your priorities by declining low-value requests.
