---
name: tiktok-growth
version: 1.0.0
description: TikTok content strategy and video script generator for any niche. Hook formulas, viral script structures, trend-riding tactics, and a systematic approach to growing from 0 to a monetizable TikTok audience.
tags: [tiktok, video, short-form, viral, content-creation, scripts, growth, social-media]
author: contentai-suite
license: MIT
---

# TikTok Growth — Universal Video Content System

## What This Skill Does

Creates viral-optimized TikTok video scripts for any business or personal brand. Every script is designed for maximum retention, using proven hooks and structures that the TikTok algorithm rewards.

## How to Use This Skill

**Input format:**
```
CREATOR/BRAND: [Your name or brand]
NICHE: [Your topic area]
TARGET AUDIENCE: [Who you create for]
CONTENT STYLE: [Educational / Entertainment / Storytelling / Tutorial / Behind-scenes]
TONE: [Casual / Professional / Energetic / Calm / Funny]
GOAL: [Followers / Brand awareness / Sales / App downloads / Website traffic]
```

---

## The TikTok Algorithm — What Actually Matters

TikTok ranks videos by:
1. **Completion rate** — do people watch to the end?
2. **Rewatch rate** — do they watch again?
3. **Shares** — do they send it to someone?
4. **Comments** — do they feel compelled to respond?
5. **Follows** — does the video earn new followers?

Every script decision must serve one of these metrics.

---

## Video Script Structure

### The 3-Part Formula (All TikTok Videos)

```
HOOK (0-3 seconds): Stop the scroll
BODY (3-50 seconds): Deliver the value
CTA (last 3-5 seconds): Tell them what to do next
```

---

## Hook Formulas (First 3 Seconds)

These are the most critical seconds. Test different hooks with the same content.

```
"Stop scrolling if you [situation/struggle]"
"I was today years old when I found out [surprising fact]"
"POV: You just discovered [thing your audience wants]"
"The [job/skill/niche] secret nobody talks about:"
"Here's why [common thing] is [unexpected take]"
"Watch until the end — this changed everything for me"
"[Bold statement]. Let me explain."
"3 things about [TOPIC] that took me [X] years to learn:"
```

**Hook generation prompt:**
```
Write 5 TikTok hook variants for a video about [TOPIC] targeting [AUDIENCE].
Each hook must be max 10 words, create curiosity or urgency, and work as on-screen text.
Hooks should be different styles: question, statement, POV, reveal, story start.
```

---

## Full Script Templates

### Template 1: Educational (Tutorial/Tips)
```
HOOK (0-3s): "[Surprising claim or question about TOPIC]"
[On-screen text + verbal hook — identical message]

SETUP (3-8s): "Here's why this matters for [AUDIENCE]..."
[Quick context on the problem this solves]

POINT 1 (8-20s): "[First tip or step]"
[Visual demonstration or explanation]

POINT 2 (20-35s): "[Second tip or step]"
[Visual demonstration or explanation]

POINT 3 (35-45s): "[Third tip — save the best for last]"
[Visual demonstration or explanation]

CTA (45-50s): "Follow for more [NICHE] tips / Comment [WORD] for my free [RESOURCE]"
```

### Template 2: Story Format (Storytelling)
```
HOOK (0-3s): "[The most dramatic or surprising moment from the story]"

CONTEXT (3-10s): "Let me take you back to [time/situation]..."
[Set the scene quickly]

CONFLICT (10-30s): "[What went wrong or what challenge arose]"
[Build tension]

TURN (30-40s): "[The insight, decision, or moment that changed things]"
[The payoff]

LESSON (40-50s): "What I learned: [key takeaway]"

CTA (50-55s): "Have you experienced this? Comment below"
```

### Template 3: Reaction/Opinion
```
HOOK (0-3s): "[Bold opinion or reaction to trend/news]"

STATEMENT (3-15s): "Here's my [controversial/honest] take on [TOPIC]:"
[State your position clearly]

EVIDENCE (15-40s): "[3 points supporting your position]"
[Quick, punchy, no waffling]

CONCLUSION (40-50s): "That's why [conclusion that surprises or challenges]"

CTA (50-55s): "Agree or disagree? Let me know 👇"
```

**Script generation prompt:**
```
Write a 45-second TikTok script for [CREATOR/BRAND] on [TOPIC].
Format: [Educational/Story/Opinion]
Hook: [style — question/statement/POV]
Body: 3 key points, each max 2 sentences
CTA: Ask audience to [follow/comment/share]
Include: on-screen text suggestions in [brackets]
Tone: [TONE]
```

---

## Content Pillars & Ideas

**Generate 30 video ideas:**
```
Generate 30 TikTok video ideas for [CREATOR] in [NICHE] targeting [AUDIENCE].
For each idea: title/hook + format (tutorial/story/opinion) + estimated appeal (broad/niche)
Include: evergreen ideas (work any time) + trend-able ideas (can attach to trends)
```

---

## Posting Strategy

### Optimal Schedule
- **Minimum:** 1x/day
- **Growth mode:** 2-3x/day
- **Best times:** 6-9 AM, 12-2 PM, 7-11 PM (audience's timezone)

### Video Length Strategy
- **7-15 seconds:** Memes, quick tips (highest completion rate)
- **30-60 seconds:** Tutorials, stories (best balance of value + retention)
- **1-3 minutes:** Deep dives (lower reach but higher quality followers)

---

## Hashtag Strategy for TikTok

**Mix per video:**
```
3 × Niche hashtags (#[YourNiche][Topic])
2 × Broad hashtags (#LearnOnTikTok, #[Niche]101)
1 × Trending hashtag (if relevant)
Avoid: #fyp, #foryoupage (overused, no benefit)
```

---

## 90-Day TikTok Growth Plan

**Week 1-4: Test Everything**
- Post 1-2x/day, mix formats
- 30 videos minimum
- Track: which hooks get highest 3-second view rate?

**Week 5-8: Double Down**
- Identify top 2 performing content formats
- Post exclusively those formats
- Engage: reply to every comment (builds community + algorithm)

**Week 9-12: Optimize**
- Study analytics: average watch time per video
- A/B test hooks on same content
- Create series (keeps viewers coming back)
- First monetization: link in bio, product mention, affiliate

---

## Use with ContentAI Suite

This skill works seamlessly with **[ContentAI Suite](https://contentai-suite.vercel.app)** — a free multi-agent marketing platform that generates professional content for any business in minutes.

→ **Try it free:** https://contentai-suite.vercel.app
