"""Logging configuration using loguru."""

import sys
from loguru import logger

from src.config import config


def setup_logger():
    """Configure loguru logger."""
    # Remove default handler
    logger.remove()

    # Add console handler with custom format
    logger.add(
        sys.stdout,
        format="<green>{time:YYYY-MM-DD HH:mm:ss}</green> | <level>{level: <8}</level> | <level>{message}</level>",
        level=config.LOG_LEVEL,
        colorize=True
    )

    # Add file handler
    logger.add(
        config.LOG_FILE,
        format="{time:YYYY-MM-DD HH:mm:ss} | {level: <8} | {name}:{function}:{line} | {message}",
        level=config.LOG_LEVEL,
        rotation="10 MB",
        retention="30 days",
        compression="zip"
    )

    return logger


# Initialize logger
log = setup_logger()
