"""
Configuration for TikTok Android Bot

Copy this file to config.py and customize your settings.
"""

# Topics to search for (used in search mode)
# Add any topics you want to engage with
TOPICS = [
    "fitness",
    "cooking",
    "travel",
    "technology",
    "gaming"
]

# Comment templates by topic
# Each topic should have 6-8 unique comment variations
COMMENTS_BY_TOPIC = {
    "fitness": [
        "That form looks perfect! What's your workout routine?",
        "Impressive progress! How long have you been training?",
        "Great motivation! What supplements do you recommend?",
        "Those results are amazing! Diet tips?",
        "Solid technique! What program are you following?",
        "Inspiring transformation! How many days a week?",
    ],
    "cooking": [
        "That looks delicious! Recipe please?",
        "Beautiful presentation! What's the cooking time?",
        "Mouth-watering! What's your secret ingredient?",
        "Perfect technique! Where did you learn that?",
        "Amazing dish! Is it difficult to make?",
        "Stunning plating! Any substitutions for dietary restrictions?",
    ],
    "travel": [
        "Incredible view! What location is this?",
        "Bucket list material! Best time to visit?",
        "Stunning destination! How many days needed?",
        "Beautiful shots! What camera do you use?",
        "Dream trip! What was the highlight?",
        "Amazing place! Any hidden gems nearby?",
    ],
    "technology": [
        "Impressive setup! What specs are you running?",
        "Great review! Worth the upgrade?",
        "Solid comparison! Which would you recommend?",
        "Clean build! What was the total cost?",
        "Useful tip! Any other tricks you recommend?",
        "Interesting approach! Does it scale well?",
    ],
    "gaming": [
        "Nice play! What's your sensitivity settings?",
        "Clutch moment! How many hours played?",
        "Great strategy! What rank are you?",
        "Clean execution! What's your setup?",
        "Impressive skill! Any tips for beginners?",
        "That was insane! What loadout are you using?",
    ]
}

# Generic comments for explore mode (when not using search)
GENERIC_COMMENTS = [
    "This is great content! Keep it up!",
    "Really enjoyed this! More please!",
    "Awesome work! Very informative!",
    "Love this! Where can I learn more?",
    "Impressive! How long did this take?",
    "Quality content! Following for more!",
    "Well done! What inspired this?",
    "This is exactly what I needed! Thanks!",
]
