---
name: TikTok Ads
description: TikTok advertising strategy, creative best practices, Spark Ads, and platform-specific optimization
metadata:
  category: marketing
  skills: ["tiktok", "ads", "social-ads", "video-ads", "short-form"]
---

## Creative Rules

- First 1-3 seconds determine everything — if viewers don't stop scrolling immediately, the rest doesn't matter
- Native content outperforms ads — shoot vertical (9:16), use trending sounds, avoid polished brand look
- Hook patterns that work: pattern interrupt, bold claim, direct question, unexpected visual, POV setup
- Text overlays are mandatory — 80%+ of users watch with sound off, burned-in captions aren't optional
- Refresh creative every 7-14 days — fatigue hits faster than any other platform, have pipeline ready

## Spark Ads

- Spark Ads use organic posts as ads — keeps comments, likes, shares visible and accumulating
- Organic engagement on Spark Ads compounds — viral potential unlike standard ads
- Creator handles can be swapped — run ads from your brand handle or creator's handle
- Require creator authorization code — valid for 7, 30, or 365 days, get longer duration upfront
- Boosting already-performing organic posts is safer than untested creative — data before dollars

## Targeting Mistakes

- Interest targeting is less accurate than Meta — TikTok's algorithm learns faster from creative signals
- Start broad, let algorithm optimize — overtargeting restricts the machine learning that makes TikTok work
- Custom Audiences need 1000+ users minimum — smaller lists won't deliver
- Lookalike percentages are different scale — 1% on TikTok is broader than 1% on Meta
- Behavior targeting (video completion, engagement) often outperforms interest targeting

## Bidding Strategy

- Learning phase needs 50 conversions in 7 days — budget must support this or campaign never optimizes
- Cost Cap is stabler than Bid Cap for beginners — limits volatility while algorithm learns
- Lowest Cost burns budget fast on launch — switch to Cost Cap after gathering initial data
- Minimum daily budget per ad group: $20-50 depending on objective — below this, delivery is inconsistent
- Don't edit campaigns during learning phase — resets progress, wait until 50 conversions

## Campaign Structure

- One campaign per objective — mixing awareness and conversion in same campaign confuses optimization
- 3-5 ad groups per campaign is optimal — enough for testing, not so many that budget fragments
- 3-5 creatives per ad group — algorithm needs options to test but too many dilutes learnings
- Separate iOS and Android campaigns post-ATT — iOS tracking is limited, don't let it pollute Android data
- Catalog ads for e-commerce — dynamic product ads outperform static for retargeting

## Platform Mechanics

- Content is served via For You algorithm, not follower graph — follower count matters less than Meta
- Hashtag challenges are paid products — organic hashtags have minimal targeting value in ads
- Comments section is public and active — negative comments kill CTR, moderate or disable if problematic
- Video completion rate is primary signal — optimize for watch time, not just clicks
- TikTok pixel has same iOS limitations as Meta — use Events API for server-side tracking

## Creative Testing

- Test hooks independently from body — first 3 seconds are separate variable from rest of video
- A/B test in creative tools, not ad platform — TikTok's native split testing is limited
- User-generated style beats studio quality — imperfect > polished on this platform
- Test creator vs brand voice — same script performed differently converts at different rates
- Winners emerge fast — if no signal in 3-5 days, creative likely won't work

## Conversion Tracking

- Standard pixel misses 40%+ of iOS conversions — implement Events API for accuracy
- View-through window defaults to 7 days — conservative window (1 day) shows truer performance
- Lead gen forms have high drop-off — keep fields to absolute minimum (name, email, phone)
- TikTok Shop has native tracking — if selling via Shop, conversion data is more complete
- Attribution is last-click by default — view-through conversions are modeled, not deterministic

## Scaling Patterns

- Increase budget 20-30% max per day — larger jumps reset learning phase
- Horizontal scaling: duplicate ad groups with different targeting — avoids audience overlap issues
- Creative is the scaling lever — same audience with new creative > same creative with forced reach
- CPMs spike during holidays and elections — plan 2-3x budget for Q4 and avoid political seasons if possible
- International markets have lower CPMs — test UK, Canada, Australia before saturating US

## Common Failures

- Repurposing Instagram Reels directly — TikTok users detect non-native content instantly
- Logo in first 3 seconds — viewers skip ads, not content. Logo at end, not beginning
- Long intros or brand statements — no one waits, hook must be immediate
- Ignoring comments — negative comments are social proof against you, moderate actively
- Expecting Meta-level tracking accuracy — TikTok attribution is less mature, expect discrepancies
