---
slug: ticktick-linux
name: ticktick-linux
description: Manage TickTick tasks (add, list, complete) via the local `tickrs` CLI.
metadata:
  openclaw:
    requires:
      bins: ["/home/david/.cargo/bin/tickrs"]
      env: ["TICKTICK_CLIENT_ID", "TICKTICK_CLIENT_SECRET"]
    emoji: "✅"
---

# TickTick

Manage tasks in TickTick.

**Prerequisite**:
You must authenticate the CLI first by running:
`~/.cargo/bin/tickrs init`

## Tools

### `ticktick_list`

List tasks from the default project (Inbox) or a specific project.

- **Parameters**:
  - `project` (string, optional): Project name to filter by.
  - `status` (string, optional): Filter by status (`incomplete` [default], `complete`).

- **Command**:
  ```bash
  /home/david/.cargo/bin/tickrs task list --json \
    {{#if project}}--project-name "{{project}}"{{/if}} \
    {{#if status}}--status {{status}}{{/if}}
  ```

### `ticktick_create`

Create a new task.

- **Parameters**:
  - `title` (string, required): The task title.
  - `content` (string, optional): Description or notes.
  - `date` (string, optional): Natural language date (e.g., "today", "tomorrow at 5pm", "next friday").
  - `project` (string, optional): Project name to add to.
  - `priority` (string, optional): `none`, `low`, `medium`, `high`.

- **Command**:
  ```bash
  /home/david/.cargo/bin/tickrs task create --json \
    --title "{{title}}" \
    {{#if content}}--content "{{content}}"{{/if}} \
    {{#if date}}--date "{{date}}"{{/if}} \
    {{#if project}}--project-name "{{project}}"{{/if}} \
    {{#if priority}}--priority {{priority}}{{/if}}
  ```

### `ticktick_complete`

Mark a task as complete by ID (get ID from `ticktick_list`).

- **Parameters**:
  - `id` (string, required): The Task ID.

- **Command**:
  ```bash
  /home/david/.cargo/bin/tickrs task complete "{{id}}" --json
  ```

### `ticktick_projects`

List all projects.

- **Command**:
  ```bash
  /home/david/.cargo/bin/tickrs project list --json
  ```
