# 思维模型增强器技能包
# Thinking Model Enhancer Skill Package

from .thinking_model_core import (
    ThinkingModelCore,
    ThinkingModel,
    ThinkingResult,
    ProblemAnalysis,
    ProblemType,
    ConfidenceLevel,
    UrgencyLevel,
    get_thinking_core
)

from .thinking_memory import (
    ThinkingMemory,
    ModelSnapshot,
    get_thinking_memory
)

from .thinking_interface import (
    ThinkingInterface,
    get_thinking_interface
)

from .initialize import (
    initialize_thinking_enhancer
)

from .advanced_features import (
    PerformanceTracker,
    PerformanceMetrics,
    ThinkingVisualizer,
    BatchProcessor,
    ModelConfigManager,
    get_performance_tracker,
    get_visualizer,
    get_batch_processor,
    get_config_manager
)

from .p2_enhancements import (
    TemplateLibrary,
    TriggerManager,
    CustomModelManager,
    TriggerType,
    TriggerMode,
    ThinkingTemplate,
    TriggerRule,
    CustomModelConfig,
    get_template_library,
    get_trigger_manager,
    get_custom_model_manager
)

from .p3_optimization import (
    ContinuousLearning,
    ModelCollaborator,
    AdvancedAnalyzer,
    LearningPattern,
    SessionData,
    ModelCollaboration,
    get_continuous_learning,
    get_model_collaborator,
    get_advanced_analyzer
)

__all__ = [
    # 核心模块
    'ThinkingModelCore',
    'ThinkingModel',
    'ThinkingResult',
    'ProblemAnalysis',
    'ProblemType',
    'ConfidenceLevel',
    'UrgencyLevel',
    'get_thinking_core',
    
    # 记忆模块
    'ThinkingMemory',
    'ModelSnapshot',
    'get_thinking_memory',
    
    # 接口模块
    'ThinkingInterface',
    'get_thinking_interface',
    
    # 初始化
    'initialize_thinking_enhancer',
    
    # 高级功能模块
    'PerformanceTracker',
    'PerformanceMetrics',
    'ThinkingVisualizer',
    'BatchProcessor',
    'ModelConfigManager',
    'get_performance_tracker',
    'get_visualizer',
    'get_batch_processor',
    'get_config_manager',
    
    # P2增强模块
    'TemplateLibrary',
    'TriggerManager',
    'CustomModelManager',
    'TriggerType',
    'TriggerMode',
    'ThinkingTemplate',
    'TriggerRule',
    'CustomModelConfig',
    'get_template_library',
    'get_trigger_manager',
    'get_custom_model_manager',
    
    # P3优化模块
    'ContinuousLearning',
    'ModelCollaborator',
    'AdvancedAnalyzer',
    'LearningPattern',
    'SessionData',
    'ModelCollaboration',
    'get_continuous_learning',
    'get_model_collaborator',
    'get_advanced_analyzer'
]
