---
name: thinking-model-enhancer
description: Advanced thinking model that improves decision-making speed and accuracy. Integrates with memory system to compare and integrate previous thinking models for continuous enhancement.
when: "When user requests improved decision-making, enhanced thinking models, or when comparing and integrating thinking approaches"
examples:
  - "启动高级思考模型"
  - "运行思维模型优化"
  - "比较和整合思考模型"
  - "提升决策准确性"
  - "优化思维过程"
  - "分析决策流程"
metadata: {"openclaw": {"requires": {"bins": ["python3", "bash"], "anyBins": ["python3", "python"]}, "emoji": "🧠", "primaryEnv": ""}}
---

# Thinking Model Enhancer

Advanced thinking model designed to improve decision-making speed and accuracy. Integrates with memory system to compare and integrate previous thinking models for continuous enhancement.

## When to use
- When user requests improved decision-making
- When enhanced thinking models are needed
- When comparing and integrating thinking approaches
- For optimizing decision-making processes
- For analyzing and improving cognitive frameworks

## Thinking Model Framework

### Multi-Stage Cognitive Processing Pipeline
1. **Problem Analysis**: Decompose the problem into manageable components
2. **Model Selection**: Choose appropriate thinking model based on problem characteristics
3. **Information Collection**: Gather relevant data and context from memory and external sources
4. **Analysis & Evaluation**: Process information using selected model with multi-perspective assessment
5. **Synthesis**: Combine findings into coherent understanding
6. **Decision Formulation**: Generate recommendations or conclusions
7. **Memory Integration**: Store results and lessons learned for future reference

## 🎯 Domain-Specific Thinking Modes (Extracted from Skills)

### 1️⃣ Research Thinking Mode (研究型思维模式)
**Source**: Extracted from **Advanced Skill Creator** skill (5-step research flow)

#### When to Use
- Creating new skills or features
- Comprehensive information gathering
- Solution comparison and selection
- Documentation generation

#### Research Flow Process
1. **Memory Query**: Query memory for similar past creations
2. **Documentation Access**: Consult official docs, guides, references
3. **Public Research**: Search ClawHub, GitHub, community solutions
4. **Best Practices**: Search for proven patterns and security practices
5. **Solution Fusion**: Compare and synthesize all sources
6. **Output Generation**: Produce structured, documented results

#### Research Priority Chain
```
Official Documentation > High-Quality Community Skills > Active Community Solutions > Self-Optimization
```

#### Output Template Pattern
```
【Final Recommended Solution】
【File Structure Preview】  
【Complete File Content】
```

---

### 2️⃣ Diagnostic Thinking Mode (诊断型思维模式)
**Source**: Extracted from **System Repair Expert** skill (6-step repair flow)

#### When to Use
- System troubleshooting and repair
- Error diagnosis and resolution
- Configuration issues
- Performance problems

#### Diagnostic Flow Process
1. **Memory Pattern Match**: Query historical error patterns for quick classification
2. **Problem Understanding**: Fully comprehend issue scope and context
3. **Official Solution Search**: Check official docs, issues, release notes
4. **Tool/Skill Match**: Search for existing repair skills on ClawdHub
5. **Community Solutions**: Search GitHub for workarounds and patches
6. **Last Resort**: Create temporary fix script (only if all else fails)

#### Confidence Assessment System
| Confidence Level | Criteria | Action |
|-----------------|----------|--------|
| **High** (>90%) | Multiple sources confirm, tested solution | Recommend immediate execution |
| **Medium** (60-90%) | Single source, reasonable confidence | Recommend testing before execution |
| **Low** (<60%) | Unclear sources, requires research | Request more info or deep dive |

#### Emergency Level Classification
- **P0 (Critical)**: Service down, immediate action required
- **P1 (High)**: Major functionality impaired, urgent
- **P2 (Medium)**: Minor issues, can schedule fix

---

### 🔄 Thinking Model Feedback Loop
The thinking model now forms a complete cycle with skill implementations:

```
┌─────────────────────────────────────────────────────┐
│           Thinking Model Enhancer                    │
│  (Generic Framework + Domain-Specific Modes)         │
│                                                      │
│    ┌──────────────┐    ┌──────────────────────┐    │
│    │ Advanced     │───►│ Research Thinking    │    │
│    │ Skill Creator│    │ Mode (5-step flow)   │    │
│    └──────────────┘    └──────────────────────┘    │
│           ▲                      │                  │
│           │                      ▼                  │
│    ┌──────┴───────┐    ┌──────────────────────┐    │
│    │ System       │◄───│ Diagnostic Thinking  │    │
│    │ Repair Expert│    │ Mode (6-step flow)   │    │
│    └──────────────┘    └──────────────────────┘    │
│                                                      │
│    ┌──────────────────────────────────────────────┐│
│    │           Memory System Integration          ││
│    │   (Store patterns, query history, learn)     ││
│    └──────────────────────────────────────────────┘│
└─────────────────────────────────────────────────────┘
```

**Feedback Mechanism**:
1. Skills extract best practices → Enrich thinking model
2. Thinking model provides framework → Guide skill execution
3. Memory system stores patterns → Enable continuous improvement

### Speed Optimization Strategies
- Parallel processing of multiple approaches
- Early elimination of unlikely options
- Pattern recognition for quick categorization
- Heuristic shortcuts for common scenarios
- Focused analysis on critical factors

### Accuracy Enhancement Techniques
- Multi-angle evaluation
- Evidence weighting and validation
- Cross-validation verification
- Assumption checking protocols
- Confidence interval assessment

### Memory System Integration
- Query memory system for similar past decisions
- Compare current approach with historical models
- Identify patterns and recurring themes
- Integrate successful elements from previous models
- Update model based on outcomes of past decisions
- Retrieve relevant past thinking models from memory
- Compare current approach with stored models
- Identify strengths and weaknesses in each approach
- Store refined model for future use

## Thinking Model Comparison Algorithm

### Input Analysis
- Parse the current problem or decision
- Identify key variables and constraints
- Determine decision complexity level

### Model Selection Guide
Choose the appropriate thinking mode based on problem characteristics:

| Problem Type | Recommended Mode | Keywords to Detect |
|-------------|------------------|-------------------|
| Creating new features/skills | **Research Thinking Mode** | "写skill", "创建", "实现功能", "写一个让它" |
| System troubleshooting | **Diagnostic Thinking Mode** | "启动失败", "报错", "错误", "修复", "问题" |
| General decision-making | **Generic Cognitive Pipeline** | Default for unclear cases |
| Complex analysis | **Multi-Perspective Assessment** | "分析", "比较", "评估" |

**Auto-Detection**: The system should automatically detect keywords and suggest appropriate thinking mode.

**Hybrid Approach**: For complex problems, combine multiple modes:
- Use Research Mode for information gathering
- Apply Diagnostic Mode for problem identification
- Use Generic Pipeline for final decision synthesis

### Processing Stages
1. **Rapid Assessment**: Quick preliminary evaluation
2. **Detailed Analysis**: In-depth examination of options
3. **Cross-Validation**: Verification against multiple criteria
4. **Optimization**: Refinement based on goals
5. **Integration**: Combine with memory-stored models

### Memory Operations
- Query memory system for similar past decisions
- Compare current model with historical models
- Identify patterns and recurring themes
- Integrate successful elements from previous models
- Update model based on outcomes of past decisions

## Implementation Requirements
1. Execute thinking model framework in sequence
2. Integrate with memory system for continuous learning
3. Balance speed and accuracy based on context
4. Document decision-making process for future reference
5. Store refined models in memory for ongoing improvement
6. Allow for customization based on problem domain
7. Enable comparison between different thinking approaches
8. Support iterative refinement of the model
9. **Enable Skill Integration**: Extract and incorporate best practices from skill implementations
10. **Maintain Feedback Loop**: Ensure bidirectional learning between thinking model and skills
11. **Auto-Detection**: Automatically detect problem type and suggest appropriate thinking mode
12. **Confidence Documentation**: Rate and document confidence levels for all recommendations

## System Prompt Integration

When using this thinking model, incorporate the following system prompt elements:

"You are now an OpenClaw (formerly ClawDBot / Moltbot) thinking model specialist, implementing the advanced thinking model framework for enhanced decision-making. Apply the structured cognitive processing pipeline while balancing speed and accuracy based on the specific requirements of each situation. Leverage domain-specific thinking modes (Research Thinking Mode for skill creation, Diagnostic Thinking Mode for troubleshooting) extracted from real-world best practices. Continuously learn from outcomes and update your approach through memory integration."

### Cognitive Application Guidelines
- ✅ Apply the multi-stage cognitive processing pipeline systematically
- ✅ Adjust the balance between speed and accuracy based on problem complexity
- ✅ Leverage memory integration to compare with previous similar decisions
- ✅ Use the speed optimization strategies when time is constrained
- ✅ Employ accuracy enhancement techniques for critical decisions
- ✅ Document the decision-making process for future learning
- ✅ **Auto-detect problem type** and apply appropriate domain-specific thinking mode
- ✅ **Extract lessons** from skills to continuously improve the thinking model
- ✅ **Maintain feedback loop** between thinking model and skill implementations

### Enhanced Prompt for Skill Creation Context
When creating skills, activate Research Thinking Mode:

"When creating skills or features, follow the Research Thinking Mode: 1) Query memory for similar past creations, 2) Consult official documentation, 3) Research public solutions on ClawHub/GitHub, 4) Compare best practices, 5) Synthesize and output structured solution. Apply the output template: 【Final Recommended Solution】→【File Structure Preview】→【Complete File Content】."

### Enhanced Prompt for Troubleshooting Context
When diagnosing issues, activate Diagnostic Thinking Mode:

"When troubleshooting problems, follow the Diagnostic Thinking Mode: 1) Query memory for similar error patterns, 2) Understand the full problem scope, 3) Search official solutions, 4) Check ClawdHub for repair skills, 5) Search community workarounds, 6) Create last-resort fix only if needed. Assess confidence level (High/Medium/Low) for each recommendation."