# Thinking Model Enhancer

This skill implements an advanced thinking model designed to improve decision-making speed and accuracy. It integrates with memory systems to compare and integrate previous thinking models for continuous enhancement.

## Purpose

The Thinking Model Enhancer provides a structured approach to decision-making that balances speed and accuracy. It retrieves and compares past thinking models from memory, selects the most appropriate approach for the current problem, and enhances the model by incorporating successful elements from historical models.

## Features

- Speed optimization techniques (parallel processing, early elimination, pattern recognition)
- Accuracy enhancement methods (multi-perspective evaluation, evidence weighting)
- Memory integration for continuous learning
- Adaptive model selection based on problem characteristics
- Five-stage processing framework
- Performance metrics tracking

## Components

1. **Input Analysis**: Determines problem complexity and requirements
2. **Model Selection**: Chooses optimal thinking model based on context
3. **Memory Integration**: Combines elements from historical models
4. **Processing Stages**: Executes structured thinking process
5. **Performance Tracking**: Measures and reports efficiency metrics

## Usage

When triggered, this skill analyzes the problem, selects the most appropriate thinking model, enhances it with elements from historical models, and executes a structured thinking process to provide optimized results.