---
name: think-cog
description: "Complex ideas need iteration, not conversation. Think → Do → Review → Repeat. CellCog completes the full loop — brainstorming, reasoning, problem-solving, strategic thinking, then executing across every modality: research, documents, visuals, data, prototypes. Like having an Alfred who doesn't just advise — he builds."
metadata:
  openclaw:
    emoji: "💭"
author: CellCog
dependencies: [cellcog]
---

# Think Cog - Your Alfred for Complex Ideas

**Complex ideas need iteration, not conversation.** Think → Do → Review → Repeat.

CellCog is the thinking partner that completes the full loop — reasons with you, then executes across every modality: research, documents, visuals, data, prototypes. Review real output, refine your thinking, iterate on substance. Like having an Alfred who doesn't just advise — he builds.

For problems where you don't know the answer upfront and the solution emerges through doing, not just discussing.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

---

## Why Think-Cog Exists

Most CellCog skills follow a pattern: you know what you want → CellCog delivers it.

But some problems don't work that way:
- You have an idea but don't know if it's possible
- You're stuck and need a different perspective
- The solution emerges through exploration, not execution
- You need to reason through tradeoffs before committing

**Think-cog is your worker agent for intellectual exploration.** You're the manager agent providing direction. CellCog thinks and works alongside you.

---

## How It Works

Unlike fire-and-forget tasks, think-cog is **conversational by design**:

```python
# Start a thinking session
result = client.create_chat(
    prompt="I'm trying to figure out the best architecture for a real-time multiplayer game...",
    notify_session_key="agent:main:main",
    task_label="architecture-thinking",
    chat_mode="agent"  # Agent mode for iterative dialogue
)

# CellCog will think through the problem and may ask clarifying questions
# You respond, building on the ideas
# The solution emerges through dialogue
```

**This is not fire-and-forget.** Think-cog expects back-and-forth conversation. Each exchange deepens understanding.

---

## When to Use Think-Cog

### Architecture & Technical Decisions

When you're weighing tradeoffs:

> "I'm building a notification system that needs to handle 10M daily users. I'm torn between:
> 1. WebSocket connections for all users
> 2. Server-sent events with polling fallback
> 3. Push notifications only
> 
> Help me think through the tradeoffs. My team is small (3 engineers) and we're on AWS."

### Business Strategy

When the path forward isn't clear:

> "My SaaS is growing but I'm not sure whether to:
> - Focus on enterprise sales (fewer customers, bigger deals)
> - Double down on self-serve (more customers, smaller ARPU)
> 
> Current metrics: 500 customers, $50 ARPU, 2 enterprise deals in pipeline worth $50K each.
> 
> Let's think through this together."

### Creative Direction

When you're exploring possibilities:

> "I want to create a video campaign for my coffee brand but I'm not sure what angle to take. The brand is:
> - Specialty single-origin coffee
> - Direct trade with farmers
> - Premium pricing ($25/bag)
> 
> Target audience is 25-40 professionals who care about quality.
> 
> Help me brainstorm directions before we commit to production."

### Problem Debugging

When you're stuck:

> "My machine learning model keeps overfitting despite:
> - Dropout layers
> - Data augmentation
> - Early stopping
> 
> Here's my architecture: [details]
> 
> Let's debug this together. What am I missing?"

### Decision Making

When you need structured thinking:

> "I have three job offers and I'm paralyzed by the decision:
> - Startup (lower pay, more equity, more risk)
> - Big tech (great pay, slower growth, stable)
> - Mid-stage scaleup (balanced, interesting problem)
> 
> Help me build a framework to think through this."

---

## The Think-Cog Philosophy

**"It's hard to know what's actually possible before you try it."**

This is CellCog's core insight. Complex problems rarely have obvious solutions. The best work happens when two smart entities—you and CellCog—exchange ideas, challenge assumptions, and discover answers together.

Think of it as pair programming for thinking:
- You provide direction and domain expertise
- CellCog provides reasoning depth and fresh perspectives
- Solutions emerge from the conversation

---

## Chat Mode for Thinking

**Use `chat_mode="agent"`** for think-cog sessions.

Why not agent team? Agent team is designed for autonomous deep work with multiple internal passes. Think-cog is about collaborative iteration WITH you. Agent mode keeps the conversation flowing naturally.

The magic happens in the back-and-forth, not in autonomous processing.

---

## Tips for Better Thinking Sessions

1. **Share context generously**: The more CellCog understands your situation, the better it can think alongside you.

2. **State your constraints**: Budget, timeline, team size, technical limitations—these shape what's possible.

3. **Be honest about uncertainty**: "I'm not sure if X is even feasible" is a great starting point.

4. **Challenge the responses**: Push back, ask "what about...", explore alternatives. Thinking improves through friction.

5. **Let solutions emerge**: Don't expect the answer in the first exchange. The best insights often come in message 4 or 5.

6. **Capture decisions**: When you reach clarity, summarize the conclusions. You can then use other CellCog skills to execute.

---

## Think-Cog vs Other Skills

| Skill | Pattern | You Know the Output? |
|-------|---------|---------------------|
| research-cog | Fire-and-forget | Yes - "Give me research on X" |
| video-cog | Fire-and-forget | Yes - "Create a video about X" |
| docs-cog | Fire-and-forget | Yes - "Create a document for X" |
| **think-cog** | **Conversational** | **No - "Help me figure out X"** |

Think-cog is for when you're in discovery mode. Other skills are for when you're in execution mode.

---

## Example Thinking Session

**You:**
> "I'm building a two-sided marketplace for freelance designers. I'm stuck on the chicken-and-egg problem—how do I get designers without clients, and clients without designers?"

**CellCog:**
> "This is the classic marketplace cold-start problem. Let me think through some approaches with you...
> 
> **Option 1: Supply-first (designers)**
> - Pros: Designers are easier to acquire, content creates SEO value
> - Cons: They'll leave if no jobs come
> 
> **Option 2: Demand-first (clients)**
> - Pros: Revenue from day one, can manually fulfill initially
> - Cons: Harder to acquire, need to deliver quality
> 
> **Option 3: Constrain the market**
> - Focus on ONE design type (e.g., logo design only)
> - Build liquidity in a narrow niche before expanding
> 
> What's your current thinking? And what resources do you have to invest in early growth?"

**You:**
> "I have about $20K for initial marketing and can do some manual matching myself. The constrained market approach is interesting—I was thinking of going broad."

**CellCog:**
> "That $20K + your time is actually a meaningful advantage. Let me build on the constrained market idea...
> 
> What if you started with:
> - **Niche**: Startup logo design only
> - **Supply**: Recruit 20-30 designers who specialize in startup branding (curated, not open signup)
> - **Demand**: Target YC companies, indie hackers, ProductHunt launchers
> 
> The manual matching you'd do becomes a feature, not a bug—'curated matches by founders who understand startups.'
> 
> This gives you:
> - Clear positioning
> - Easier SEO/content ('startup logo design' vs 'design marketplace')
> - Higher willingness to pay from funded startups
> - Story for press/ProductHunt
> 
> Thoughts? Or should we explore other niches?"

The conversation continues, ideas refine, and eventually you arrive at a clear strategy to execute.
