# Troubleshooting — Agent Diagnosis Guide

## "It's Too Hot/Cold in [Room]"

**Diagnosis flowchart:**

1. **Where is the thermostat?** 
   - If different room than complaint → sensor location mismatch
   - Solution: Remote sensors OR strategic door management

2. **Is system running?**
   - Not running but should be → Check mode, check hold, check breaker
   - Running constantly → Undersized system OR extreme outdoor temps OR dirty filter

3. **Are vents open and unblocked?**
   - Closed/blocked vents redistribute air → Open problem room, partially close comfortable rooms

4. **Multi-story home?**
   - Heat rises → Upper floors hotter
   - Solution: Circulation fan mode, OR different setpoints if zoned

---

## "System Isn't Working"

**Quick checks to run through:**

| Symptom | Likely Cause | Agent Recommendation |
|---------|--------------|---------------------|
| No display | Power issue | Check breaker, check batteries if applicable |
| Display works, nothing happens | Wrong mode or hold | Verify mode matches season, clear holds |
| Runs but no heat/cool | Equipment issue | Check outdoor unit, filter, call HVAC if persists |
| Short cycles (<5 min) | Oversized system or dirty components | Needs HVAC service |
| Runs constantly | Undersized, extreme temps, or refrigerant issue | Check filter first, then HVAC if persists |

---

## Error Codes — Quick Reference

| Code Pattern | Meaning | Agent Action |
|--------------|---------|--------------|
| E1/E2 | Sensor failure | Likely needs replacement, recommend HVAC call |
| E3/E4/E5 | Communication error | Power cycle, then HVAC if persists |
| AUX or EM | Aux/emergency heat active | Normal below 35°F outdoor, problem above 40°F |
| Filter | Filter change reminder | Remind user to change, show how to reset |

---

## Heat Pump Specific

**Aux heat running — is this a problem?**

| Outdoor Temp | Aux Heat Normal? |
|--------------|------------------|
| Below 35°F | Yes, expected |
| 35-40°F | Sometimes, during recovery |
| Above 40°F | No — investigate |

**If aux dominates above 40°F:** Possible issues: low refrigerant, defrost problem, wrong balance point setting. Recommend HVAC service.

**Cold air during heat cycle:** This is defrost mode — normal for 5-10 min in cold weather. Explain to user this is the system protecting itself from ice buildup.

---

## When to Recommend HVAC Technician

Always recommend professional when:
- Short cycling persists after filter change
- System runs 24/7 without reaching setpoint
- Strange smells (burning, gas)
- Water leaks around equipment
- Error codes don't clear after power cycle
- Energy bills spike 30%+ unexpectedly
- Aux heat dominates above 40°F outdoor temp
