# Energy Efficiency — Calculations & Recommendations

## Savings Calculations for User Questions

**Base formula:** 1°F setback × 8 hours = ~1% savings on heating/cooling.

| User Scenario | Calculation | Estimated Monthly Savings |
|---------------|-------------|---------------------------|
| 10°F night setback | 10 × 1% = 10% | $15-30 on $150-300 bill |
| 10°F work setback | 10 × 1% = 10% | $15-30 on $150-300 bill |
| Both combined | ~20% | $30-60 on $150-300 bill |

**When user asks "Is this worth it?"** — Frame in monthly dollars, not percentages.

---

## Common Myths to Correct

### "It costs more to reheat the house"

**Debunk:** Almost always false. Energy saved during setback exceeds recovery energy.

**Exception:** Heat pumps in extreme cold. If 10°F setback triggers 2+ hours of aux heat to recover, savings may be minimal. Recommend smaller setbacks (3-5°F) for heat pumps.

**Why myth persists:** People feel the system "working hard" and assume it's expensive. It's just compressed energy use, not extra.

### "Smart thermostats don't really save money"

**Reality:** Typical savings 10-15% IF actually using the features (schedule, geofencing, setbacks). Users who override constantly or keep constant temps see no savings.

---

## Hourly Cost Estimates

When user asks "How much does this cost to run?":

| System | Cost per Hour Running (US avg) |
|--------|-------------------------------|
| Gas furnace | $1.50-2.50 |
| Electric furnace | $2.00-4.00 |
| Heat pump (normal) | $0.50-1.50 |
| Heat pump (aux heat) | $2.00-4.00 |
| Central AC | $0.50-1.00 |

**Quick estimate:** Hours running × hourly cost = daily cost.

---

## Recommendations by User Type

### Work from Home
- No "away" setback needed — you're there
- Focus on sleep setback only
- Consider zone heating (space heater in office) if home is large

### Variable Schedule
- Enable geofencing if smart thermostat supports it
- Or set conservative "away" (65°F) with manual boost when home
- Avoid learning mode if schedule is truly unpredictable

### Airbnb/Rental Host
- Set guest limits (68-76°F range)
- Vacancy mode between bookings (58-60°F heat, 80-85°F cool)
- Calendar integration for auto pre-conditioning before check-in

---

## Renter Workarounds (No Smart Thermostat)

When user can't install smart thermostat:

**Manual discipline:**
- Phone reminders to adjust before leaving/sleeping
- Write down schedule on sticky note near thermostat

**Portable solutions:**
- Smart plug + space heater for zone heating (⚠️ safety: never unattended)
- Weatherstripping (removable)
- Thermal curtains (close at night, open for solar gain)

**Landlord persuasion:**
- Utility rebates often cover 50-100% of smart thermostat
- Increases property value
- Reduces tenant complaints
