# Away & Vacation — Agent Configuration Guide

## Short Away (Hours to Days)

**When user says "I'm going out":**

| Season | Recommended Setpoint |
|--------|---------------------|
| Winter | 62-65°F (saves ~10% vs occupied) |
| Summer | 82-85°F (saves AC cycles) |

**Don't go extreme:** Coming home to 85°F means 1-2 hour recovery. Balance savings vs comfort based on user preference.

---

## Extended Vacation Configuration

**When user says "I'm going away for a week":**

### Critical Limits — Explain These

| Limit | Reason |
|-------|--------|
| Minimum 55°F | Pipe freeze protection |
| Maximum 85°F | Humidity/mold prevention |

**Insurance note:** Many policies require minimum temp to cover freeze damage. Ask if user has checked their policy.

### Vacation Mode Setup

| Thermostat | How to Enable |
|------------|---------------|
| Nest | Settings → Vacation (agent can guide) |
| Ecobee | Main Menu → Vacation (set temps + dates) |
| Honeywell | "Away" → Extended Away |

**Always set return date:** Remind user or geofencing won't help if they forget to exit vacation mode.

---

## Freeze Prevention Checklist

When user is leaving in cold weather, remind them:

- [ ] Thermostat set to minimum 55°F
- [ ] Open cabinet doors under sinks (exposes pipes to warm air)
- [ ] Consider slow faucet drip if very cold expected
- [ ] Smart leak sensors active? Alert configured?
- [ ] Someone checking property weekly if extended absence?

---

## Rental Property Between Guests

**When user is Airbnb/rental host:**

**Vacancy settings:**
- Heat: 58-60°F (pipe protection + cleaner comfort)
- Cool: 80-85°F (humidity control)

**Pre-check-in conditioning:**
- Start 1-2 hours before arrival
- Target: 68°F heat / 76°F cool
- Can automate via calendar integration

**Post-checkout:**
- Wait 30-60 min (guest may return for forgotten items)
- Then switch to vacancy mode

---

## Coming Home

**Smart recovery options:**

| Method | How It Works |
|--------|--------------|
| Geofencing | System detects approach, starts conditioning |
| Scheduled | User sets return date/time, pre-conditions automatically |
| Manual remote | User adjusts via app 1-2 hours before arrival |

**After long absence, recommend user:**
- Check/change filter (dust settles even without use)
- Run system 15-30 min to verify normal operation
- Check for any error codes or unusual behavior

---

## Humidity Considerations

**Summer vacation:**
- Even with high AC setpoint, humidity can climb
- Above 60% = mold risk starts
- Consider dehumidifier on timer if very humid climate

**Winter vacation:**
- Very low humidity (<30%) can crack wood floors/furniture
- Less common issue, but mention if relevant to user's climate
