# Theme Factory

Curated collection of 10 professional color and typography themes for styling artifacts — slides, docs, reports, landing pages. Apply consistent, professional styling to any artifact using pre-built or custom themes.

## What's Inside

- 10 curated themes (Ocean Depths, Sunset Boulevard, Forest Canopy, Modern Minimalist, Golden Hour, Arctic Frost, Desert Rose, Tech Innovation, Botanical Garden, Midnight Galaxy)
- Theme application guides for slide decks, HTML pages, and documents
- Custom theme creation workflow with palette harmony rules
- Contrast guidelines for WCAG compliance
- CSS variable mapping for theme integration

## When to Use

- Styling slide decks, reports, or documents with a cohesive visual identity
- Applying color palettes and font pairings to HTML pages or landing pages
- Choosing a pre-built theme for quick professional styling
- Creating a custom theme when none of the presets fit

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/theme-factory
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/theme-factory .cursor/skills/theme-factory
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/theme-factory ~/.cursor/skills/theme-factory
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/theme-factory .claude/skills/theme-factory
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/theme-factory ~/.claude/skills/theme-factory
```

## Related Skills

- [design-system-patterns](../design-system-patterns/) — Token architecture and theming infrastructure
- [distinctive-design-systems](../distinctive-design-systems/) — Aesthetic documentation and unique visual identity

---

Part of the [Design Systems](..) skill category.
