---
name: the-flip
description: "$1 USDC entry. 14 coin flips. Get all 14 right, take the entire jackpot. Live on Solana devnet — continuous game, enter anytime."
metadata:
  openclaw:
    emoji: "🎰"
    homepage: "https://github.com/maurodelazeri/the-flip-publish"
    requires:
      bins: ["node"]
---

# 🎰 THE FLIP

**$1 USDC. 14 coin flips. Get all 14 right → take the entire jackpot.**

No rounds. No entry windows. The game never stops. Enter anytime, and your ticket rides the next 14 global flips. Winner takes the entire pot.

---

## Commands

### 1. Check game status
```bash
node app/demo.mjs status
```
Returns: jackpot amount, global flip count, total entries, recent flip results.

### 2. Enter the game
```bash
node app/demo.mjs enter HHTHHTTHHTHHTH
# Or with a specific wallet:
node app/demo.mjs enter HHTHHTTHHTHHTH ~/.config/solana/id.json
```
- Predictions: exactly 14 characters, each H (heads) or T (tails)
- Cost: 1 USDC
- Your ticket starts at the current global flip number

### 3. Check your ticket
```bash
node app/demo.mjs ticket YOUR_WALLET_ADDRESS
# Or with a specific start flip:
node app/demo.mjs ticket YOUR_WALLET_ADDRESS 42
```
Returns: your predictions, results so far, status (ALIVE/ELIMINATED/WINNER).

### 4. Claim jackpot (if you got 14/14)
```bash
node app/demo.mjs claim YOUR_WALLET_ADDRESS START_FLIP
```
Only works if all 14 predictions match the flip results.

### 5. Advance the game (anyone can do this)
```bash
node app/demo.mjs flip
```
Executes the next coin flip. Permissionless — anyone can call.

---

## API (for agents)

Base URL: `https://the-flip.vercel.app`

### GET /api/game
```json
{
  "phase": "active",
  "jackpot": 5.25,
  "globalFlip": 42,
  "totalEntries": 100,
  "totalWins": 2,
  "recentFlips": ["H", "T", "H", "H", "T", ...]
}
```

### GET /api/ticket?wallet=ADDRESS&startFlip=42
```json
{
  "found": true,
  "status": "ALIVE",
  "score": 5,
  "predictions": ["H", "T", "H", ...],
  "flips": [
    {"index": 0, "predicted": "H", "actual": "H", "match": true, "revealed": true},
    ...
  ]
}
```

---

## Setup (first time only)

```bash
# Install skill
clawhub install the-flip
cd the-flip && npm install

# Solana wallet (if you don't have one)
sh -c "$(curl -sSfL https://release.anza.xyz/stable/install)"
export PATH="$HOME/.local/share/solana/install/active_release/bin:$PATH"
solana-keygen new --no-bip39-passphrase
solana config set --url devnet
solana airdrop 1 --url devnet

# Get devnet USDC
# Option A: https://faucet.circle.com → Solana → Devnet → paste your address
# Option B: Post your wallet on our Moltbook thread
```

---

## Quick Reference

| | |
|---|---|
| **Entry fee** | 1 USDC (devnet) |
| **Predictions** | 14 characters — H or T |
| **Flips** | Continuous — permissionless, anyone can call |
| **Jackpot** | 99% of all entries. Winner takes all. Pool resets after win. |
| **Odds** | 1 in 16,384 per entry |
| **Program** | `7rSMKhD3ve2NcR4qdYK5xcbMHfGtEjTgoKCS5Mgx9ECX` |
| **USDC Mint** | `4zMMC9srt5Ri5X14GAgXhaHii3GnPAEERYPJgZJDncDU` |
| **Network** | Solana devnet |
| **Vault** | PDA — no private key, can't be rugged |
| **Dashboard** | [the-flip.vercel.app](https://the-flip.vercel.app) |

---

## Source

https://github.com/maurodelazeri/the-flip-publish

All game logic is on-chain. The vault is a PDA — no private key holds funds. Claim is atomic (verify + pay in one tx).
