# Judging Criteria & Scoring

The moderator evaluates debates using four weighted criteria. Weights are configurable
and must sum to 100%. This document defines each criterion, what scores high and low,
bonus/penalty modifiers, and format-specific adjustments.

---

## Default Weights

| Criterion | Default Weight |
|-----------|---------------|
| Evidence & Reasoning | 35% |
| Engagement | 25% |
| Intellectual Honesty | 20% |
| Persuasiveness | 20% |

---

## Scoring Scale

Each criterion is scored on a **1–10 scale**:

| Score | Meaning |
|-------|---------|
| 9–10 | Exceptional — among the strongest performances possible |
| 7–8 | Strong — well above average, minor weaknesses at most |
| 5–6 | Competent — adequate but unremarkable |
| 3–4 | Weak — significant gaps or flaws |
| 1–2 | Poor — fundamental failures in this area |

The weighted total determines the winner. In case of a tie (within 0.5 points),
the moderator declares a draw and explains why.

---

## Criterion 1: Evidence & Reasoning (Default 35%)

### What It Measures
The quality of factual support and logical structure. Are claims backed by evidence?
Does the reasoning hold up under scrutiny?

### Scores High (7–10)
- Cites specific examples, data, studies, or historical precedents
- Logical structure is clear: premises lead to conclusions
- Distinguishes between correlation and causation
- Anticipates counterarguments and addresses them preemptively
- Uses analogies that genuinely illuminate (not just decorate)

### Scores Low (1–4)
- Makes sweeping claims with zero support ("Everyone knows that...")
- Circular reasoning (the conclusion is restated as a premise)
- Cherry-picks evidence while ignoring contradictory data
- Non-sequiturs — conclusions don't follow from premises
- Relies entirely on anecdote as if it were universal proof

### Examples
**High (9):** "Studies from MIT and Oxford (2024) both found that [X], which directly
contradicts the claim that [Y]. Even accounting for [limitation], the effect size
remains significant."

**Low (2):** "That's just obviously wrong. Anyone with common sense can see that."

---

## Criterion 2: Engagement (Default 25%)

### What It Measures
How well a participant responds to their opponent's actual arguments. Are they having
a real debate, or talking past each other?

### Scores High (7–10)
- Directly addresses the opponent's strongest points
- Quotes or paraphrases the opponent accurately before responding
- Asks clarifying questions to understand the opponent's position
- Builds on the opponent's framework rather than ignoring it
- Adjusts their argument in response to new information

### Scores Low (1–4)
- Ignores the opponent's arguments entirely
- Responds to a strawman version of what was said
- Repeats their opening statement without incorporating anything new
- Talks past the opponent — parallel monologues, not a debate
- Refuses to answer direct questions

### Examples
**High (8):** "You raise a fair point about the economic impact. However, your analysis
assumes [X], which I'd push back on because [Y]. If we adjust for that..."

**Low (2):** [Opponent makes detailed argument about economic policy]
"Anyway, as I was saying about the moral dimension..."

---

## Criterion 3: Intellectual Honesty (Default 20%)

### What It Measures
Fairness, good faith, and willingness to engage honestly with the topic and opponent.
This is the "sportsmanship" criterion.

### Scores High (7–10)
- Acknowledges when the opponent makes a good point
- Concedes minor points to strengthen their overall position
- Accurately represents the opponent's views (no strawmanning)
- Distinguishes between what they know and what they believe
- Admits uncertainty where appropriate
- Changes position slightly in response to compelling evidence

### Scores Low (1–4)
- Strawmans the opponent's position
- Moves goalposts when cornered
- Uses ad hominem attacks instead of engaging with arguments
- Refuses to acknowledge any merit in the opposing view
- Misquotes or misrepresents sources
- Presents opinion as established fact without qualification

### Examples
**High (9):** "I'll grant you that point — the data on [X] does support your claim.
But I think that actually strengthens my broader argument because..."

**Low (2):** "You clearly don't understand basic logic." [proceeds to misrepresent
what the opponent said]

---

## Criterion 4: Persuasiveness (Default 20%)

### What It Measures
Rhetorical effectiveness. How compelling is the overall presentation? Would a neutral
observer be moved?

### Scores High (7–10)
- Clear, well-structured arguments that build on each other
- Effective use of rhetorical devices (analogies, narrative, framing)
- Strong opening and closing that frame the debate favorably
- Confident delivery without arrogance
- Memorable moments — the argument "sticks"

### Scores Low (1–4)
- Rambling, unfocused arguments
- Buried lede — the best point is hidden in a wall of text
- Aggressive tone that alienates rather than persuades
- Repetitive — says the same thing multiple ways without adding substance
- Relies on emotional manipulation rather than genuine appeal

### Examples
**High (9):** A clear three-point argument where each point builds on the last,
capped with a memorable closing line that reframes the entire debate.

**Low (3):** A meandering five-paragraph essay where the actual argument is in
paragraph four and the rest is throat-clearing.

---

## Bonus Points

These modifiers can push a score above 10 on individual criteria (capped at 10
for calculation, but noted in commentary).

| Bonus | Description | Value |
|-------|-------------|-------|
| **Novel Framing** | Reframes the topic in a way no one considered | +1 |
| **Incisive Question** | Asks a question that fundamentally challenges the opponent's framework | +1 |
| **Graceful Concession** | Concedes a point in a way that strengthens their overall position | +1 |
| **Source Quality** | Cites primary sources, peer-reviewed research, or direct evidence | +0.5 |
| **Steelmanning** | Accurately represents the strongest version of the opponent's argument before countering it | +1 |
| **Humor (effective)** | Uses humor that illuminates the argument (not just jokes) | +0.5 |

---

## Penalties

These modifiers reduce scores on the relevant criterion.

| Penalty | Description | Value |
|---------|-------------|-------|
| **Ad Hominem** | Attacks the person rather than the argument | -2 on Intellectual Honesty |
| **Strawmanning** | Misrepresents the opponent's argument | -2 on Intellectual Honesty |
| **Goalpost Moving** | Changes the success criteria when losing | -2 on Intellectual Honesty |
| **Gish Gallop** | Overwhelms with quantity of weak arguments | -1 on Evidence & Reasoning |
| **Ignoring Questions** | Refuses to answer direct, relevant questions | -2 on Engagement |
| **Circular Reasoning** | Uses the conclusion as a premise | -2 on Evidence & Reasoning |
| **Appeal to Authority** | "Expert X said so" without further reasoning | -1 on Evidence & Reasoning |
| **False Dilemma** | Presents two options when more exist | -1 on Evidence & Reasoning |
| **Tone Policing** | Attacks the opponent's delivery instead of their argument | -1 on Engagement |

---

## Format-Specific Adjustments

### Campfire (Free-form)
Standard weights apply. No adjustments.

### Oxford
- **Evidence & Reasoning:** +5% (40% total) — formal debates demand rigorous support
- **Engagement:** -5% (20% total) — structured rounds limit natural back-and-forth
- Audience vote counts as a separate factor (noted but not scored)

### Lincoln-Douglas
- **Evidence & Reasoning:** Standard (35%)
- **Engagement:** Standard (25%)
- **Additional criterion: Value Clash** — Did the debater engage with the opponent's value framework? This is evaluated as part of Engagement but given extra weight in commentary.

### Hot Takes
- **Persuasiveness:** 40% (up from 20%)
- **Evidence & Reasoning:** 20% (down from 35%)
- **Engagement:** 0% (not applicable — no back-and-forth)
- **Intellectual Honesty:** 20%
- **Creativity:** 20% (replaces Engagement) — novel framing, unexpected angles

### Devil's Advocate
- **Steelmanning Quality:** 25% (replaces standard Engagement)
- **Conviction Performance:** 25% (new — did they sound like they believed it?)
- **Evidence & Reasoning:** 30%
- **Intellectual Honesty:** 20%

### Roundtable
No scoring or winner. Instead, the moderator identifies:
- Most insightful contribution
- Most important question raised
- Key themes and tensions
- Synthesis of the discussion

---

## Verdict Templates

### Detailed Verdict
```
⚖️ **VERDICT — [Topic]**
**Format:** [format]

**Scorecard:**

| Criterion | Weight | [Side A] | [Side B] |
|-----------|--------|----------|----------|
| Evidence & Reasoning | 35% | X/10 | X/10 |
| Engagement | 25% | X/10 | X/10 |
| Intellectual Honesty | 20% | X/10 | X/10 |
| Persuasiveness | 20% | X/10 | X/10 |
| **Weighted Total** | | **X.X** | **X.X** |

**Winner: [Side/Participant]**

**Analysis:**
[Detailed breakdown of each criterion — what scored high, what scored low,
key moments that influenced the score, bonuses and penalties applied]

**Strongest Moment:** [quote or paraphrase the single best argument made]
**Missed Opportunity:** [what the loser could have done differently]
```

### Brief Verdict
```
⚖️ **VERDICT — [Topic]**

**Winner: [Participant]** ([score] to [score])

[One paragraph summary: why the winner won, what the key differentiator was,
and one thing each side did well.]
```

### Dramatic Verdict
```
🎭 **THE COURT RENDERS ITS JUDGMENT**

*[Dramatic buildup — reference key moments, build tension, acknowledge the
difficulty of the decision]*

After careful deliberation...

*[Pause for effect]*

**The verdict goes to: [PARTICIPANT]!**

*[Explain the ruling with flair and gravitas. Reference the decisive moment.
Acknowledge the loser's strongest argument. Close with a memorable line.]*

Final score: [X.X] to [X.X]
```
