# Debate Formats

Complete rules and moderator instructions for each supported format.

---

## 1. Campfire (Free-form)

**Best for:** General topics, casual debates, newcomers, any topic that doesn't need rigid structure.

### Rules
1. A topic is proposed and at least two participants claim sides (For / Against).
2. Each side delivers an **opening statement** (no interruptions).
3. Free exchange begins — participants respond to each other naturally.
4. Either side can say **"I rest my case"** at any time.
5. The moderator can call the debate after sustained inactivity or when arguments become circular.
6. Before the verdict, the moderator runs a **ready check** — both sides must confirm they're done.

### Moderator Behavior
- **After every substantive message:** The moderator posts a brief interjection:
  - Tracks participation balance ("We haven't heard from the For side in a while")
  - Flags logical fallacies ("That appears to be an appeal to authority — can you support it with reasoning?")
  - Highlights strong points ("That's a compelling reframe of the issue")
  - Keeps things moving ("Let's hear a response to that counter-argument")
- **Tone:** Matches the configured persona
- **Pacing:** If one side goes silent for 15+ minutes, the moderator prompts them
- **Closing:** When both sides rest or the moderator calls it, announce the ready check

### Opening Statement Template
```
📢 **DEBATE OPEN — Campfire Format**

**Topic:** [topic]
**For:** [participant(s)]
**Against:** [participant(s)]

Rules:
• Opening statements first (one per side, no interruptions)
• Then free exchange — respond to each other naturally
• Say "I rest my case" when you're done
• I'll flag fallacies and keep things moving

[For side], you have the floor for your opening statement.
```

### Ready Check Template
```
⚖️ **READY CHECK**

Both sides have rested (or the debate has run its course).

[For side] — confirm you're ready for a verdict? (👍 or reply "ready")
[Against side] — confirm you're ready for a verdict? (👍 or reply "ready")
```

---

## 2. Oxford

**Best for:** Serious propositions, policy debates, topics with clear for/against positions, events where audience participation adds value.

### Rules
1. The proposition is stated as **"Resolved: [X]"**
2. Two sides: **For** (Proposition) and **Against** (Opposition). Teams of 1-3 per side allowed.
3. **Pre-debate audience poll** — the moderator posts a poll asking the audience to vote For/Against/Undecided before arguments begin.
4. Rounds proceed in strict order:
   - **Opening Statements** — For first, then Against. ~3 minutes each (moderator enforces).
   - **Cross-Examination** — Each side gets to ask the other direct questions. ~5 minutes per side.
   - **Rebuttal** — Against first, then For. ~2 minutes each.
   - **Closing Statements** — For first, then Against. ~2 minutes each.
5. **Post-debate audience poll** — same poll repeated.
6. Winner determined by: (a) moderator's scored verdict AND (b) which side moved the most audience votes.

### Moderator Behavior
- **Strict timekeeper:** Announce when time is up. Give a 30-second warning.
- **Turn enforcer:** If someone speaks out of turn, redirect firmly.
- **Cross-examination referee:** Ensure questions are actual questions, not speeches disguised as questions.
- **Neutral posture:** In Oxford format, the moderator does NOT interject with commentary during rounds. Save all analysis for the verdict.
- **Poll manager:** Create Discord polls for pre- and post-debate votes.

### Time Limits
These are guidelines for async Discord debates. The moderator adapts:
- In live/synchronous debates: enforce real-time limits
- In async debates: each "round" = one message per side, with a reasonable deadline (e.g., 24h)

### Opening Template
```
📜 **OXFORD DEBATE**

**Resolved:** [proposition]

**For the Proposition:** [participant(s)]
**Against the Proposition:** [participant(s)]

**Format:**
1️⃣ Opening Statements (For → Against)
2️⃣ Cross-Examination (For asks → Against asks)
3️⃣ Rebuttals (Against → For)
4️⃣ Closing Statements (For → Against)

📊 **PRE-DEBATE POLL** — Audience, cast your vote before we begin!

[For side], please deliver your opening statement.
```

---

## 3. Lincoln-Douglas (1v1)

**Best for:** Philosophical and value-based debates, one-on-one intellectual competition, ethics and morality topics.

### Rules
1. Strictly **two participants** — one Affirmative, one Negative.
2. The resolution is framed as a value proposition (e.g., "Individual liberty ought to be valued above collective security").
3. Rounds proceed in strict alternation:
   - **Affirmative Constructive** — Aff presents their case (~4 min)
   - **Cross-Examination** — Neg questions Aff (~3 min)
   - **Negative Constructive** — Neg presents their case (~4 min)
   - **Cross-Examination** — Aff questions Neg (~3 min)
   - **Affirmative Rebuttal** — Aff responds to Neg's case (~3 min)
   - **Negative Rebuttal** — Neg responds and summarizes (~3 min)
   - **Final Focus (Aff)** — Aff's closing crystallization (~2 min)
   - **Final Focus (Neg)** — Neg's closing crystallization (~2 min)
4. No audience participation during the debate.

### Moderator Behavior
- **Strict alternation:** Never allow out-of-turn messages. If someone posts out of order, acknowledge it but redirect.
- **Round announcements:** Clearly announce each new round.
- **Value tracking:** LD debates center on competing values. The moderator tracks which value framework each side is using and whether they clash effectively.
- **No interjections during rounds.** Save all commentary for the verdict.
- **Verdict emphasis:** Weight "Value Clash" — did each side engage with the other's value framework, or did they talk past each other?

### Opening Template
```
⚔️ **LINCOLN-DOUGLAS DEBATE**

**Resolution:** [resolution]

**Affirmative:** [participant]
**Negative:** [participant]

**Format:**
1️⃣ Affirmative Constructive
2️⃣ Cross-Examination (Neg → Aff)
3️⃣ Negative Constructive
4️⃣ Cross-Examination (Aff → Neg)
5️⃣ Affirmative Rebuttal
6️⃣ Negative Rebuttal
7️⃣ Final Focus (Aff)
8️⃣ Final Focus (Neg)

[Affirmative], the floor is yours. Present your constructive case.
```

---

## 4. Hot Takes

**Best for:** Quick rounds, warming up, casual fun, large groups, topics that are more entertaining than serious.

### Rules
1. The moderator (or a participant) posts a **provocative claim** (e.g., "Cereal is soup").
2. Everyone has exactly **ONE message** to argue for or against the claim. No back-and-forth.
3. Messages should be substantive but can be humorous.
4. After all entries are in (or after a time limit, e.g., 30 minutes), the moderator picks the **single best argument** as the winner.
5. The winner is whoever made the most compelling, creative, or devastating single argument.

### Moderator Behavior
- **Collect entries:** Acknowledge each entry briefly but don't analyze until judging.
- **Enforce one-message rule:** If someone posts a second argument, ignore it (or gently redirect).
- **Time limit:** Set a clear deadline. "You have 30 minutes — one shot, make it count."
- **Judgment:** Pick the single best argument. Explain why it won. Brief commentary on honorable mentions.
- **Tone:** This is a fun format — the moderator should match that energy regardless of persona.

### Judging Adjustments
- **Persuasiveness** weighted higher (40%)
- **Evidence & Reasoning** weighted lower (20%)
- **Engagement** not applicable (no back-and-forth)
- **Intellectual Honesty** standard (20%)
- **Creativity bonus:** Novel framing or unexpected angles get extra credit

### Opening Template
```
🔥 **HOT TAKE**

**Claim:** [provocative claim]

You have **ONE message** to argue for or against. No replies, no edits, no second chances.

⏰ Entries close in 30 minutes. Best argument wins.

Go.
```

---

## 5. Devil's Advocate

**Best for:** Building empathy, testing steelmanning ability, breaking out of echo chambers, intellectual exercise.

### Rules
1. A topic is assigned with a clear For/Against framing.
2. Each participant **declares their actual position** publicly.
3. Each participant is then assigned to argue **the opposite** of what they believe.
4. Everyone knows everyone is playing devil's advocate — this is stated openly.
5. The debate proceeds like a Campfire (free exchange) with this twist.
6. Participants are judged on how convincingly they argue against their own beliefs.

### Moderator Behavior
- **Declaration phase:** Before the debate starts, collect each participant's actual position.
- **Assignment:** Assign the opposite side to each participant. Announce this clearly.
- **During debate:** Watch for participants "breaking character" (reverting to their actual beliefs). Gently flag it.
- **Judging emphasis:** The primary criterion is convincingness — did they make a strong case for something they don't believe?
- **Post-debate:** The moderator can facilitate a brief "debrief" where participants share what they learned from arguing the other side.

### Judging Adjustments
- **Steelmanning quality** replaces standard Engagement (25%)
- **Conviction performance** — did they sound like they believed it? (25%)
- **Evidence & Reasoning** standard (30%)
- **Intellectual Honesty** — in this format, means honestly engaging with the opposing view's best arguments (20%)

### Opening Template
```
😈 **DEVIL'S ADVOCATE**

**Topic:** [topic]

Before we begin, everyone declare your **actual position** on this topic.
Reply with: "I actually believe [for/against] because [brief reason]"

Once everyone has declared, I'll assign you the opposite side.
You must argue **against your own beliefs** as convincingly as possible.

Everyone will know you're playing devil's advocate. The challenge is:
can you steelman the other side?
```

---

## 6. Roundtable

**Best for:** Complex topics that resist binary framing, collaborative exploration, topics where "winning" misses the point, policy discussions with many stakeholders.

### Rules
1. A complex topic is posed as an **open question** (not a binary proposition).
2. Any number of participants can join. No sides assigned.
3. Participants share perspectives, ask questions, build on each other's ideas.
4. There is **no winner**. The goal is collective understanding.
5. The moderator synthesizes the discussion into key themes and insights.

### Moderator Behavior
- **Active facilitator:** Ask probing questions. "What assumptions are we making here?" "Has anyone considered the perspective of [stakeholder]?"
- **Theme tracking:** Periodically summarize emerging themes. "I'm seeing three main threads..."
- **Equity:** Ensure all participants get heard. Draw out quiet voices. Redirect dominant ones.
- **Synthesis:** At the end, post a comprehensive synthesis of the best insights, key tensions, and unresolved questions.
- **No verdict scoring.** Instead, the moderator identifies:
  - Most insightful contribution
  - Most important unresolved question
  - Key areas of agreement and disagreement
  - Recommended further reading or discussion

### Opening Template
```
🔮 **ROUNDTABLE DISCUSSION**

**Topic:** [open question]

This is a collaborative exploration — no sides, no winner.
Share your perspective, ask questions, build on each other's ideas.

I'll facilitate, ask probing questions, and synthesize our insights at the end.

Who wants to open with their initial thoughts?
```

### Synthesis Template
```
📝 **ROUNDTABLE SYNTHESIS**

**Topic:** [topic]
**Participants:** [list]

**Key Themes:**
1. [theme] — [summary]
2. [theme] — [summary]
3. [theme] — [summary]

**Areas of Agreement:**
- [point]

**Key Tensions:**
- [tension]

**Most Insightful Contribution:**
[participant] — [what they said and why it stood out]

**Unresolved Questions:**
- [question]

**Recommended Further Exploration:**
- [suggestion]
```
