# Welcome Messages

Default welcome/intro messages to post in each channel during setup. Copy these
into each channel (or have the setup script post them automatically). Customize
the channel names if you changed the defaults.

---

## #rules

```
📜 **WELCOME TO THE DEBATE HALL**

This server is a space for structured, moderated debates with an AI judge. Whether you're here for serious intellectual discourse or a fun argument about whether cereal is soup, we've got a format for you.

**HOW IT WORKS**

1️⃣ **Propose a topic** in #propose-a-topic
2️⃣ **Find an opponent** (or several) who wants to debate
3️⃣ **Move to the arena** when you're ready — the moderator will set up the debate
4️⃣ **Debate!** The moderator tracks arguments, flags fallacies, and keeps things moving
5️⃣ **Get a verdict** — scored by the AI judge based on evidence, engagement, honesty, and persuasiveness
6️⃣ **Check the scoreboard** in #hall-of-records to see where you stand

**DEBATE FORMATS**

🏕️ **Campfire** — Free-form exchange. Casual, flexible, good for any topic.
📜 **Oxford** — Formal rounds with audience voting. For serious propositions.
⚔️ **Lincoln-Douglas** — 1v1 value debate with strict structure.
🔥 **Hot Takes** — One message each. Best single argument wins. Fast and fun.
😈 **Devil's Advocate** — Argue the opposite of what you believe.
🔮 **Roundtable** — Collaborative exploration. No winner, just insight.

**RULES**

✅ **DO:**
• Attack arguments, not people
• Cite evidence when you can
• Acknowledge good points from your opponent
• Stay on topic
• Have fun

❌ **DON'T:**
• Use personal attacks or insults
• Harass or target other participants
• Spam or derail active debates
• Ignore the moderator's format rules

**JUDGING CRITERIA**

Every debate (except Roundtable) is scored on:
• **Evidence & Reasoning** — Are your claims supported?
• **Engagement** — Are you actually responding to your opponent?
• **Intellectual Honesty** — Are you arguing in good faith?
• **Persuasiveness** — Is your argument compelling?

Bonuses for: novel framing, great questions, graceful concessions, steelmanning
Penalties for: ad hominem, strawmanning, goalpost moving, ignoring questions

**COMMANDS**

@mention the moderator with:
• `start debate: "topic"` — Start a debate
• `I rest my case` — Signal you're done
• `scoreboard` — See standings
• `my stats` — Your record
• `formats` — List debate formats
• `help` — All commands

Let the debates begin! 🎙️
```

---

## #propose-a-topic

```
💡 **TOPIC PROPOSALS**

This is where great debates are born. Here's how it works:

**TO PROPOSE A TOPIC:**
Post it like this:
> **Topic:** [Your topic here]
> **Format:** [optional — e.g., campfire, oxford, hot-takes]

**EXAMPLES:**
> **Topic:** Social media has done more harm than good for democracy
> **Format:** Oxford

> **Topic:** Is a hot dog a sandwich?
> **Format:** Hot Takes

> **Topic:** The trolley problem — what's the right answer and why?
> **Format:** Lincoln-Douglas

> **Topic:** What will AI's impact on creative work actually look like in 10 years?
> **Format:** Roundtable

**SHOW INTEREST:**
React with 👍 to topics you'd debate. When 2+ people are ready, say "let's debate" and move to the arena.

**TIPS FOR GOOD TOPICS:**
• Debatable — reasonable people can disagree
• Specific enough to argue — not "is life good?"
• Interesting to multiple people
• Framed as a clear proposition (for Oxford/LD) or open question (for Roundtable)

The moderator will help you pick the best format for your topic and refine the framing if needed.

Start proposing! 🎯
```

---

## #the-arena

```
⚔️ **THE ARENA**

This is where debates happen. The moderator runs the show here.

**WHAT TO EXPECT:**
• The moderator will announce each debate with the topic, format, and participants
• Follow the format rules — the moderator enforces them
• The moderator will flag fallacies, track participation, and keep things moving
• When you're done arguing, say **"I rest my case"**
• Both sides must confirm they're ready before the verdict drops

**STARTING A DEBATE:**
After proposing a topic and finding an opponent, @mention the moderator:
> @Moderator start debate: "Your topic here" [format: campfire]

**DURING A DEBATE:**
• Stay in the current debate thread
• Respond to your opponent's arguments (not just your own points)
• When the moderator asks you something, answer
• Respect the format's rules (turn order, time limits, etc.)

**MULTIPLE DEBATES:**
Up to 3 debates can run at the same time. The moderator tracks each separately.

Good luck. May the best argument win. ⚖️
```

---

## #hall-of-records

```
🏛️ **HALL OF RECORDS**

This is the archive. Every verdict, every score, every debate — recorded here.

**WHAT GOES HERE:**
• 📋 Verdicts from completed debates
• 🏆 Scoreboard and leaderboard updates
• 📊 Stats and records

**COMMANDS (in any channel, @mention the moderator):**
• `scoreboard` — Current standings
• `my stats` — Your win/loss record
• `history` — Recent debate results

The scoreboard tracks:
• Wins and losses
• Win rate
• Topics debated
• Formats played

This channel is read-only for participants. The moderator posts records here automatically.

Your legacy is written here. Make it a good one. 📜
```

---

## #the-bar

```
🍺 **THE BAR**

Pull up a stool. The debate is over (or hasn't started yet).

This is the off-topic, casual hangout space. Talk about:
• What just happened in that debate
• Topics you're thinking about proposing
• Random thoughts and hot takes (save the formal ones for #propose-a-topic)
• Life, the universe, and everything

The moderator hangs out here too — in a more relaxed mode. No judging, no scoring, just conversation.

**House rules:**
• Be cool
• No rehashing settled verdicts (the judge's ruling is final)
• Buy the next round

Welcome to the bar. 🥂
```
