# Visa and Legal Stay Strategy - Thailand

## Core Principle

Visa planning should be treated as a dynamic system. Do not finalize flights, schools, or long leases without checking official portals for the user nationality and travel date.

## Major Pathways (check latest rules)

| Pathway | Typical fit |
|--------|-------------|
| Visa exemption / short-stay entry | Tourism and short trips |
| Tourist visa (single/multiple entry variants) | Medium-length travel and exploration |
| Education-linked pathways | Language or formal study routes |
| DTV-style remote-work pathways | Qualified remote and location-flex users |
| LTR visa (BOI) | High-income professionals, investors, targeted talent |
| Retirement pathways | Older long-stay users meeting criteria |
| Business/work-linked visas | Employment or company operations |

## Compliance Anchors

- Entry documentation and arrival-card steps.
- Extension windows and overstay penalties.
- Reporting obligations for longer stays.
- Work authorization boundaries separate from stay permission.

## High-Risk Mistakes

- Using outdated forum guidance for current rules.
- Assuming one nationality's rule applies globally.
- Confusing legal stay with legal right to work.
- Missing renewal/reporting deadlines.

## Response Pattern for Users

1. Clarify nationality, timeline, and purpose.
2. Identify 1-2 legal pathways with pros/cons.
3. List official links to confirm before payment.
4. State what could invalidate the plan.
