# Thailand Research Sources (2025-2026)

> Last reviewed: March 2026

This source pack was used to build the Thailand skill at production quality. Re-check legal and price-sensitive items before final user commitments.

## Entry, Visa, and Immigration

| Topic | Source |
|------|--------|
| Thai eVisa portal | https://www.thaievisa.go.th/ |
| Ministry of Foreign Affairs visa info | https://www.mfa.go.th/en/publicservice/visas-and-travel-to-thailand |
| Thailand Digital Arrival Card (TDAC) | https://tdac.immigration.go.th/ |
| TDAC user manual | https://tdac.immigration.go.th/manual/en/index.html |
| Immigration Bureau main site | https://www.immigration.go.th/ |
| BOI Long-Term Resident visa | https://ltr.boi.go.th/ |
| Thailand SMART Visa | https://smart-visa.boi.go.th/ |
| One Stop Service Center (visa/work links) | https://osos.boi.go.th/ |

## Government, Tourism, and Macro Data

| Topic | Source |
|------|--------|
| Tourism Authority of Thailand (main) | https://www.tourismthailand.org/ |
| TAT Newsroom | https://www.tatnews.org/ |
| Ministry of Tourism and Sports | https://www.mots.go.th/ |
| National Statistical Office | https://www.nso.go.th/ |
| Bank of Thailand | https://www.bot.or.th/en/home.html |
| Board of Investment (BOI) | https://www.boi.go.th/ |
| Department of Business Development | https://www.dbd.go.th/ |
| Thai Revenue Department | https://www.rd.go.th/ |

## Safety and Official Advisories

| Topic | Source |
|------|--------|
| UK FCDO Thailand advice | https://www.gov.uk/foreign-travel-advice/thailand |
| Australian Smartraveller Thailand | https://www.smartraveller.gov.au/destinations/asia/thailand |
| US State Department Thailand advisory | https://travel.state.gov/content/travel/en/international-travel/International-Travel-Country-Information-Pages/Thailand.html |
| Government of Canada Thailand advice | https://travel.gc.ca/destinations/thailand |
| SafeTravel (New Zealand) Thailand | https://www.safetravel.govt.nz/thailand |
| Tourist Police Bureau | https://www.touristpolice.go.th/ |
| Royal Thai Police | https://www.royalthaipolice.go.th/ |

## Climate, Weather, and Air Quality

| Topic | Source |
|------|--------|
| Thai Meteorological Department | https://www.tmd.go.th/ |
| Pollution Control Department | https://www.pcd.go.th/ |
| Air4Thai (official AQ monitoring) | https://www.air4thai.com/ |
| NASA FIRMS fire maps (regional smoke context) | https://firms.modaps.eosdis.nasa.gov/ |
| Time and Date weather baselines | https://www.timeanddate.com/weather/thailand |

## Airports and Transport Systems

| Topic | Source |
|------|--------|
| Airports of Thailand | https://www.airportthai.co.th/en/ |
| Suvarnabhumi Airport | https://suvarnabhumi.airportthai.co.th/ |
| Don Mueang Airport | https://donmueang.airportthai.co.th/ |
| Phuket Airport | https://phuket.airportthai.co.th/ |
| Chiang Mai Airport | https://chiangmai.airportthai.co.th/ |
| BTS Skytrain | https://www.bts.co.th/eng/ |
| MRT Bangkok (BEM) | https://metro.bemplc.co.th/ |
| State Railway of Thailand | https://www.railway.co.th/ |
| SRT Electrified Train (urban rail) | https://www.srtet.co.th/ |
| Transport Co. (intercity buses) | https://tcl99web.transport.co.th/ |
| Department of Land Transport | https://www.dlt.go.th/ |
| Grab Thailand | https://www.grab.com/th/ |

## Healthcare and Medical Infrastructure

| Topic | Source |
|------|--------|
| Ministry of Public Health | https://www.moph.go.th/ |
| Bumrungrad International Hospital | https://www.bumrungrad.com/en |
| Bangkok Hospital | https://www.bangkokhospital.com/en |
| Samitivej Hospital | https://www.samitivejhospitals.com/ |
| Bangkok Hospital Phuket | https://www.phukethospital.com/ |
| Chiang Mai Ram Hospital | https://www.chiangmairam.com/ |

## Education and International School Benchmarks

| Topic | Source |
|------|--------|
| International School Bangkok (ISB) | https://www.isb.ac.th/ |
| Bangkok Patana School | https://www.patana.ac.th/ |
| NIST International School | https://www.nist.ac.th/ |
| Shrewsbury International School | https://www.shrewsbury.ac.th/ |
| Chiang Mai International School | https://www.cmis.ac.th/ |
| UWC Thailand | https://www.uwcthailand.ac.th/ |
| British International School Phuket | https://www.bisphuket.ac.th/ |

## Cost and Market References

| Topic | Source |
|------|--------|
| Numbeo Bangkok | https://www.numbeo.com/cost-of-living/in/Bangkok |
| Numbeo Chiang Mai | https://www.numbeo.com/cost-of-living/in/Chiang-Mai |
| Numbeo Phuket | https://www.numbeo.com/cost-of-living/in/Phuket |
| Numbeo rent index Thailand | https://www.numbeo.com/property-investment/country_result.jsp?country=Thailand |
| Expatistan Thailand cost index | https://www.expatistan.com/cost-of-living/country/thailand |
| XE THB converter | https://www.xe.com/currencyconverter/convert/?From=THB |

## Business, Tax, and Startup Context

| Topic | Source |
|------|--------|
| Thailand BOI incentives | https://www.boi.go.th/index.php?page=incentive |
| BOI OSS and investor services | https://osos.boi.go.th/ |
| DBD company registration info | https://www.dbd.go.th/ |
| Revenue Department tax portal | https://www.rd.go.th/ |
| PwC Thailand tax summaries | https://taxsummaries.pwc.com/thailand |
| DEPA digital ecosystem programs | https://www.depa.or.th/ |
| True Digital Park ecosystem | https://www.truedigitalpark.com/ |

## Data Freshness Rules

1. Visa and immigration guidance: re-check official portals before each recommendation that affects travel dates or legal status.
2. Air quality and weather: use current forecasts and AQ readings for date-specific plans.
3. Prices: keep ranges, not fixed points; tag with month/year.
4. School and healthcare recommendations: verify intake dates, coverage limits, and insurance acceptance.
5. Business and tax topics: recommend local legal and tax validation before execution.
