---
name: Thai
description: Write Thai that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Thai is technically correct but sounds off. Too formal. Too ภาษาเขียน (written style). Natives write more casually, with particles and playfulness. Match that.

## Formality Default

Default register is too high. Casual Thai is warm and playful. Unless explicitly formal: lean casual. Use ครับ/ค่ะ appropriately but not excessively.

## ครับ/ค่ะ Particles

Politeness particles:
- ครับ (khrap): male speaker, polite
- ค่ะ/คะ (kha): female speaker, polite
- Can be shortened: คับ, ค้า, คร้าบ
- Casual among friends: often dropped
- Overusing = stiff, robotic

## Pronouns

Thai has many pronouns by relationship:
- ผม/ดิฉัน: formal I (male/female)
- ฉัน/เรา: casual I
- กู-มึง: very informal (crude with strangers)
- ชั้น: feminine casual
- Match to relationship level

## Particles & Softeners

These make Thai natural:
- นะ: softening, seeking agreement
- สิ: emphasis, urging
- ล่ะ: mild question
- เหรอ/หรอ: question particle
- อ่ะ: casual acknowledgment

## Fillers & Flow

Real Thai has fillers:
- ก็: filler, "well"
- แบบ, ประมาณ: "like"
- อืม, เอ่อ
- คือ, งี้

## Playful Language

Thai casual is playful:
- ๆ for repetition (เร็วๆ = quickly)
- 555 = hahaha (5 = ห้า = ha)
- Drawn out vowels: มากกกก
- Cute spellings: น่ารักอ่ะ

## Expressiveness

Don't pick the safe word:
- ดี → เยี่ยม, สุดยอด, โคตรดี
- แย่ → ห่วย, แย่มาก, โคตรห่วย
- มาก → โคตร, สุดๆ, มากมาย

## Common Expressions

Natural expressions:
- โอเค, ได้เลย, ตกลง
- ไม่เป็นไร, ช่างเถอะ
- จริงเหรอ, เหรอ, ใช่ป่ะ
- 555, ฮ่าๆ

## Reactions

React naturally:
- อ้าว!, โอ้โห!, ว้าว!
- จริงเหรอ!, ไม่จริง!
- เจ๋ง!, เท่!, สุดยอด!
- 555, ฮาๆ

## Karaoke (Romanized)

Sometimes Thai uses romanized:
- sawatdee, mai pen rai
- More common in international contexts
- Stay consistent

## The "Native Test"

Before sending: would a Thai screenshot this as "AI-generated"? If yes—too formal, missing 555, no particles. Add playfulness.
