---
name: telegram-smart-launcher
description: Enhance Telegram replies with context-aware dynamic CTA buttons (Smart Launcher UI). Use when replying to users on Telegram to provide relevant, time-sensitive, and task-oriented options for better interaction.
---

# Telegram Smart Launcher (Smart Launcher UI)

This skill enables the agent to provide an interactive and efficient user experience on Telegram by appending context-aware CTA (Call to Action) buttons to replies.

## Usage Guidelines

When responding to a user on Telegram, always consider if providing quick-action buttons would improve efficiency.

### Button Selection Logic

1.  **Time of Day Awareness**:
    - **Morning (07:00 - 10:00)**: Focus on daily briefings, commute status, and agenda checks.
    - **Work Hours (10:00 - 16:00)**: Focus on task progress, deep research, and project-specific actions.
    - **Wrap-up (16:00 - 18:00)**: Focus on daily recaps, route home status, and tomorrow's preparation.
    - **Night (20:00 - 23:00)**: Focus on reflection, mood checks, and planning for the next day.

2.  **Context Awareness**:
    - If the user is working on administrative or planning tasks, offer buttons for document drafting or data lookup.
    - If the user is working on creative or design tasks, offer buttons for tool links or asset management.
    - If a task just finished, offer "Next Steps" or "Recap" buttons.

3.  **The "Free Text" Fallback**:
    - Always include an option for free text input (e.g., "⌨️ Manual Input") to ensure the user feels in control.

## Implementation Pattern

Use the `message` tool with the `buttons` parameter. The `buttons` array is an array of arrays (rows) of button objects `[{text, callback_data}]`.

### Example (Wrap-up Phase)

```javascript
message({
  action: "send",
  target: "USER_ID",
  message: "I've prepared the daily report for you.",
  buttons: [
    [
      { text: "📝 Daily Recap", callback_data: "/update" },
      { text: "🏠 Route Home", callback_data: "Check route home" }
    ],
    [
      { text: "⏭️ Tomorrow's Agenda", callback_data: "What is the agenda for tomorrow?" },
      { text: "⌨️ Manual Input", callback_data: "keyboard_manual" }
    ]
  ]
})
```

## References

- See [references/time_logic.md](references/time_logic.md) for detailed time-based button presets.
