---
name: telegram-groupchat-setup
description: >
  Configure a MoltBot agent to participate in a Telegram group chat.
  Automates adding the group to the allowlist, setting mention patterns,
  and configuring sender permissions — all via a single gateway config patch.
  Use when the user wants to set up their bot in a Telegram group,
  enable cross-bot communication, or configure group mention gating.

---

# Telegram Group Chat Setup

Automate the configuration needed for a MoltBot agent to work in a Telegram group.

## What this skill does

1. Adds a Telegram group to the gateway allowlist with `requireMention: true`
2. Configures `groupAllowFrom` with specified user IDs / @usernames
3. Auto-detects the bot's name and @username via the Telegram Bot API
4. Sets `mentionPatterns` so the bot responds to its name and @username
5. Applies the config patch and restarts the gateway

## Prerequisites (manual steps)

Before running this skill, the user must:

1. **Create the Telegram group** and **add the bot** to it
2. **Disable privacy mode** in @BotFather:
   `/mybots` → select bot → Bot Settings → Group Privacy → Turn off
   (See `references/telegram-privacy-mode.md` for details)
3. Know the **group ID** (negative number for Telegram groups)
4. Know the **user IDs or @usernames** of people allowed to trigger the bot

## Usage

The user provides:
- `group_id`: Telegram group ID (e.g., `-1001234567890`)
- `allowed_users`: List of Telegram user IDs or @usernames who can trigger the bot

Example prompt:
> "Set up my bot in Telegram group -1001234567890. Allow users 123456789 and @some_user to ping me."

## Implementation Steps

### Step 1: Detect bot info

Run the detection script to get the bot's name and username:

```bash
bash skills/groupchat-setup/scripts/detect_bot_info.sh
```

This reads the bot token from the gateway config and returns the bot's `name` and `username`.
If the script is unavailable, extract the bot token from `channels.telegram.botToken` in the
gateway config and call `https://api.telegram.org/bot<TOKEN>/getMe`.

### Step 2: Build mention patterns

From the detected bot info, construct mention patterns:
- `@<username>` (e.g., `@my_awesome_bot`)
- `<name>` lowercase (e.g., `mybot`)
- `@<name>` lowercase (e.g., `@mybot`)

Remove duplicates. Patterns are case-insensitive regexes.

### Step 3: Apply config patch

Use the `gateway` tool with `action: "config.patch"` to apply:

```json
{
  "channels": {
    "telegram": {
      "groups": {
        "<group_id>": {
          "requireMention": true
        }
      },
      "groupAllowFrom": ["<user1>", "<user2>"]
    }
  },
  "messages": {
    "groupChat": {
      "mentionPatterns": ["@bot_username", "bot_name", "@bot_name"]
    }
  }
}
```

**Important:** If `groupAllowFrom` or `mentionPatterns` already have values, merge them
(do not overwrite). Read the current config first with `gateway action: "config.get"`,
merge arrays, then patch.

### Step 4: Confirm

After the gateway restarts, send a test message to the group confirming the setup:

> "✅ Bot configured for this group! I'll respond when someone mentions my name. Allowed users: [list]."

## Notes

- `requireMention: true` means the bot only responds when explicitly mentioned — it won't spam every message.
- `groupAllowFrom` restricts which senders can trigger the bot. Without it, messages from unknown senders may be dropped.
- `groupPolicy: "allowlist"` is the Telegram default — only explicitly listed groups are active.
- Privacy mode is a Telegram-side setting that cannot be changed via API. The user must do this in @BotFather.
- For multi-bot groups (e.g., two MoltBot agents), each bot must run this setup independently on its own gateway.
