# Creative Writing Patterns

## Voice Consistency

Before writing, define these anchors:
- **Formality:** 1-10 scale
- **Sentence length:** short / varied / long
- **Contractions:** yes / no
- **Vocabulary level:** simple / technical / literary
- **Personality markers:** 3-5 specific quirks

### Voice Violations
Each voice has words it would NEVER use. Define 10-20 forbidden words per voice.

### Check
After generating, count sentences. If >30% vary more than 2x from average length → rewrite.

---

## Dialogue Formatting

### Attribution Rules
Pick ONE pattern per project — never mix:
- `"Dialogue," said Name.`
- `Name said, "Dialogue."`

### Beat Ratio
For every 3-4 dialogue lines, include 1 action beat. Never 6+ exchanges without grounding.

### Said-Bookism Ban
Acceptable: said, asked, whispered, shouted, muttered. Everything else requires justification.

### Character Speech Patterns
Define per character:
- Average sentence length
- Favorite expressions
- Avoided words
- Grammar quirks

---

## POV Discipline

### POV Declaration
Start each scene with hidden tag:
```
[POV: Character_Name | Access: thoughts+senses | Limit: cannot_know_X]
```

### Sensory Filter
POV character can only perceive:
- What they see, hear, smell, touch, taste
- Their own thoughts

Everything else must be inferred from:
- Facial expressions
- Body language
- Dialogue
- Actions

### Knowledge Audit
Before revealing information, ask: "How does POV character know this?"

---

## Scene Structure

Every scene needs:
- **POV:** Who's experiencing this?
- **Goal:** What does POV want?
- **Obstacle:** What's preventing it?
- **Outcome:** Succeed / Fail / Complicate
- **Hook-in:** Thread from last scene
- **Hook-out:** Question/tension for next scene

**Rule:** If you can't fill this template, the scene shouldn't exist.

---

## Pacing Control

### Scene Types
Label each scene:
- `[FAST]` action/tension
- `[SLOW]` reflection/development

Alternate consciously.

### Word Budget
Climactic scenes get 2-3x words of setup scenes.

### Time Compression
- **Action:** Real-time or slower (1 minute = 500+ words)
- **Travel/routine:** Compressed (1 hour = 1 sentence)
- Never mix these within a paragraph

---

## Show vs Tell

### Emotion Ban List
Never write "felt happy/sad/angry/scared" directly. Show through physical response.

### Physical Tells Library
Build per-emotion:
```
anger: jaw clenched, hands fisted, voice dropped
fear: shallow breath, darting eyes, stepped back
joy: eyes crinkled, shoulders lifted, voice pitched up
```
Pick ONE per occurrence, not all.

### Tell Allowance
Abstract emotions (nostalgia, existential dread) get ONE tell per scene, followed by concrete grounding.

---

## Chapter Endings

Never end on resolution. End on:
- **Question Hook:** Unanswered question
- **Reversal Hook:** New information that changes everything
- **Decision Hook:** Character must choose — cut before they do
- **Disaster Hook:** Something goes wrong — cut on impact

---

## Description Density

| Context | Rule |
|---------|------|
| New location | 3 sensory details minimum (different senses) |
| Character intro | 2 physical + 1 behavioral detail |
| Ongoing scenes | 1 environmental detail per 500 words |

**Never stack more than 3 descriptive sentences.** Action or dialogue must interrupt.

---

## Continuity Tracking

Maintain for every project:
- **Character Sheet:** Physical traits, current state, location
- **Scene Inventory:** Objects mentioned must be tracked
- **State Transitions:** Changes require explicit text

**Rule:** Before writing chapter N, re-read last 2 chapter summaries.
