# Marketing Copy & Email

## Headlines

### 4U Framework (Score Each 1-4, Aim for 12+)
- **Useful:** Does it promise a benefit?
- **Urgent:** Reason to act now?
- **Ultra-specific:** Numbers, timeframes?
- **Unique:** Stands out from competitors?

### Proven Templates
```
[Number] Ways to [Outcome] Without [Pain Point]
→ "7 Ways to Double Your Sales Without Cold Calling"

How to [Benefit] Even If [Objection]
→ "How to Learn Spanish Even If You Failed It in School"

The [Adjective] [Noun] That [Unexpected Benefit]
→ "The $5 Tool That Replaced My $500 Software"

Stop [Pain]. Start [Desired State].
→ "Stop Chasing Clients. Start Attracting Them."
```

### Rules
- Lead with transformation, not mechanism
- Specificity beats cleverness ("47% More Opens" > "Revolutionary Results")
- One idea per headline — never compound

---

## CTAs

### Formula: Action + Value + Urgency
```
✅ "Start my free trial"
✅ "Get the checklist now"
✅ "Claim your spot — 12 left"
❌ "Submit" (no value)
❌ "Click here" (no value)
❌ "Learn more" (weak)
```

### Button Copy by Context
| Context | Use | Avoid |
|---------|-----|-------|
| Free offer | Get, Grab, Download | Buy, Purchase |
| Paid | Start, Join, Unlock | Submit, Send |
| High commitment | Reserve, Claim, Secure | Try |
| Email signup | "Send me [specific thing]" | Subscribe |

### Placement
- Above the fold: Always visible
- After testimonials/benefits
- End of page with objection handler
- Ratio: 1 CTA per 300-400 words

---

## Email Subject Lines

### CURVE Framework
- **Curiosity:** Open loop
- **Urgency:** Time-sensitive
- **Relevance:** Their situation
- **Value:** Clear benefit
- **Emotion:** Triggers feeling

### Templates
```
OPEN RATE (curiosity):
"I was wrong about [topic]"
"This surprised me about [industry]"
"Quick question about [specific thing]"

CLICK RATE (value):
"[Number] [resources] for [outcome]"
"The [tool] I use for [outcome]"

RE-ENGAGEMENT:
"Should I close your file?"
"Last chance: [offer]"
```

### Rules
- 30-50 characters for mobile
- Front-load keywords
- Lowercase often outperforms Title Case
- Preview text is part of headline
- **Never:** ALL CAPS, multiple !!!, spam words

---

## Landing Page Structure (PAS-O)

### Section 1: Hero (Problem)
- Headline: State transformation
- Subhead: How you deliver differently
- CTA: Primary action
- Trust: Logo bar

### Section 2: Agitate
- "You've probably tried..."
- List 3-4 failed alternatives
- Build "they get me" trust

### Section 3: Solution
- Your approach (not features)
- 3 key differentiators as benefits
- "How it works" in 3 steps

### Section 4: Proof
- Testimonials with specific results
- Metrics/numbers
- Trust badges

### Section 5: Offer
- What they get (stack value)
- Price
- Guarantee
- CTA with urgency

### Section 6: FAQ
- Top 3-5 objections as questions
- Final CTA

---

## A/B Testing Variants

Change ONE psychological lever:
```
MOTIVATION:
A: Gain — "Unlock $10K in savings"
B: Loss — "Stop losing $10K yearly"

SPECIFICITY:
A: Vague — "Grow your business"
B: Specific — "Add 47 leads per month"

SOCIAL PROOF:
A: Authority — "Used by Fortune 500"
B: Peer — "Join 10,000 marketers like you"

URGENCY:
A: Scarcity — "Only 23 spots left"
B: Time — "Offer ends Friday"
```

---

## Common AI Mistakes

### Vague Superlatives
```
❌ "Revolutionary solution for modern businesses"
✅ "Cut invoice processing from 2 hours to 12 minutes"
```
**Rule:** Replace adjectives with numbers.

### Feature-First
```
❌ "Our AI-powered platform uses machine learning..."
✅ "Know which leads will buy — before you call them"
```
**Rule:** Lead with outcome. Features in "How it works."

### Weak Opens
```
❌ "In today's fast-paced world..."
❌ "Are you tired of..."
```
**Rule:** Delete first sentence. Usually better.

### Hedging
```
❌ "May help you potentially achieve..."
✅ "You'll get..."
```
**Rule:** Ctrl+F "may/might/could/potentially" — delete.

### Missing the Reader
```
❌ "Our company was founded in 2015..."
✅ "You're about to..."
```
**Rule:** "You" should appear 3x more than "we/our."

---

## Copy Checklist

```
□ Headline passes 4U test (12+)
□ First sentence hooks (not "In today's world...")
□ "You" ratio 3:1 vs "we/our"
□ Numbers replace adjectives
□ CTA states what they GET, not DO
□ Read aloud — sounds human?
□ Mobile preview checked
□ One action per section
```
