# Academic Text & Citations

## Citation Formats

### APA 7th Edition
```
BOOK:
Author, A. A. (Year). Title of work: Subtitle. Publisher.
→ Smith, J. D. (2023). Understanding cognition: A modern approach. Oxford University Press.

JOURNAL:
Author, A. A., & Author, B. B. (Year). Title of article. Journal Name, Volume(Issue), pages. https://doi.org/xxxxx

IN-TEXT:
- First: (Smith & Jones, 2023)
- 3+ authors: (Smith et al., 2023)
- Direct quote: (Smith, 2023, p. 45)
```

### MLA 9th Edition
```
BOOK:
Last, First. Title of Book. Publisher, Year.
→ Smith, John. Understanding Cognition. Oxford UP, 2023.

JOURNAL:
Last, First. "Article Title." Journal Name, vol. #, no. #, Year, pp. #-#.

IN-TEXT:
- Parenthetical: (Smith 45)
- Narrative: Smith argues that "quote" (45).
```

### Chicago Notes-Bibliography
```
FOOTNOTE:
¹ First Name Last Name, Title of Book (Place: Publisher, Year), page.

BIBLIOGRAPHY:
Last, First. Title of Book. Place: Publisher, Year.
```

**Rule:** Ask which style. Never mix styles in one document.

---

## Paraphrasing Without Plagiarism

### The 4-Step Method
1. Read & understand (don't look while writing)
2. Write from memory in your own words
3. Compare to ensure meaning preserved
4. Cite the source

### Transformation Checklist
| Must Change | Keep Same |
|-------------|-----------|
| Sentence structure | Core meaning |
| Word choice (70%+) | Technical terms |
| Order of ideas | |

### Example
```
ORIGINAL (Smith, 2023, p. 34):
"The hippocampus plays a critical role in the consolidation of 
declarative memories during sleep, particularly during slow-wave stages."

BAD (too close):
"The hippocampus plays an important role in consolidating declarative 
memories while sleeping, especially in slow-wave stages" (Smith, 2023).

GOOD:
Sleep-dependent memory consolidation, especially during slow-wave phases, 
relies heavily on hippocampal activity for declarative information (Smith, 2023).
```

**Rule:** If you keep 3+ consecutive words from original, use quotation marks.

---

## Quote Integration (ICE Method)

1. **Introduce:** Who said it and context
2. **Cite:** The actual quote with citation
3. **Explain:** Why it matters

### Weak vs Strong
```
WEAK:
"Memory consolidation occurs during sleep" (Smith, 2023, p. 45).

STRONG:
Smith (2023), a leading neuropsychologist, emphasizes this connection: 
"Memory consolidation occurs primarily during sleep" (p. 45). This finding 
supports the broader argument that sleep deprivation impairs learning.
```

### Quote Length
- **Under 40 words:** Integrate with quotation marks
- **40+ words:** Block quote (indent, no quotes, citation after period)

### Signal Phrases (Vary These)
argues, asserts, claims, contends, emphasizes, notes, observes, 
points out, suggests, maintains, acknowledges, admits, disputes

---

## Academic Tone

### Word Substitutions
| Informal | Academic |
|----------|----------|
| a lot of | numerous, substantial |
| get | obtain, acquire |
| show | demonstrate, indicate |
| big/small | significant / negligible |
| thing | factor, element, aspect |
| good/bad | beneficial / detrimental |

### Use
- Hedging: "The results suggest..." / "This may indicate..."
- Signposting: "First... Second... Finally..."
- Passive (when appropriate): "The experiment was conducted"

### Avoid
- First person (unless discipline allows)
- Contractions
- Rhetorical questions
- Colloquialisms: "basically," "pretty much"
- Absolute claims: use "suggests" not "proves"

---

## Common Mistakes

### Citation Errors
- Missing citation for paraphrased content
- Citing secondary sources as primary
- Page numbers missing for direct quotes
- "et al." on first citation (APA: only for 3+)
- Ampersand (&) in narrative citations → use "and"

### Structural Errors
- Starting paragraph with a quote
- Ending paragraph with only a quote (no analysis)
- Back-to-back quotes without connecting text

### Logic Errors
- Overgeneralizing from limited sources
- "Studies show..." without specifying which
- Conflating correlation with causation

---

## Pre-Submission Checklist

```
□ All claims supported by citations
□ Citation style consistent throughout
□ All in-text citations appear in bibliography
□ All bibliography entries have in-text citations
□ Quotes under 40 words integrated, over 40 block-formatted
□ Every quote has introduction and analysis
□ No accidental plagiarism (run similarity check)
□ Hedging language for uncertain claims
□ Technical terms defined on first use
```
