---
name: text-transform
description: Text transformation, regex, diff, format conversion, and JSON manipulation.
version: 1.0.1
metadata:
  openclaw:
    emoji: "📝"
    homepage: https://text.agentutil.net
    always: false
---

# text-transform

Regex operations, line-level diffs, text transforms (slugify, case, count, truncate), markdown/HTML conversion, and JSON manipulation.

## Data Handling

This skill sends text to an external API for structural transformation. **You must always ask the user before sending any text that was not generated by you.** Only use this skill on agent-generated content (e.g. formatting your own output, converting markup you produced, counting words in a draft you wrote) unless the user explicitly requests otherwise. Never send user documents, private messages, or file contents without direct user instruction to do so.

The service performs stateless text operations — no data is stored, logged, or retained beyond the immediate response.

## Endpoints

### Text Transform

```bash
curl -X POST https://text.agentutil.net/v1/transform \
  -H "Content-Type: application/json" \
  -d '{"input": "Hello World", "operations": ["slugify", "word_count", "lowercase"]}'
```

Operations: slugify, truncate, word_count, char_count, line_count, uppercase, lowercase, title_case, reverse, trim.

### Regex

```bash
curl -X POST https://text.agentutil.net/v1/regex \
  -H "Content-Type: application/json" \
  -d '{"input": "order 123 and 456", "pattern": "\\d+", "operation": "match_all", "flags": "g"}'
```

Operations: match, match_all, replace, test.

### Diff

```bash
curl -X POST https://text.agentutil.net/v1/diff \
  -H "Content-Type: application/json" \
  -d '{"a": "line one\nold line", "b": "line one\nnew line"}'
```

### Format Conversion

```bash
curl -X POST https://text.agentutil.net/v1/convert \
  -H "Content-Type: application/json" \
  -d '{"input": "# Hello", "from": "markdown", "to": "html"}'
```

### JSON Operations

```bash
curl -X POST https://text.agentutil.net/v1/json \
  -H "Content-Type: application/json" \
  -d '{"input": "{\"key\": \"value\"}", "operation": "format"}'
```

Operations: parse, format, validate, minify, query (with `path` param).

## Response Format

```json
{
  "results": {"word_count": 2, "slugify": "hello-world", "lowercase": "hello world"},
  "request_id": "abc-123",
  "service": "https://text.agentutil.net"
}
```

## Pricing

- Free tier: 10 queries/day, no authentication required
- Paid tier: $0.001/query via x402 protocol (USDC on Base)

## Privacy

Stateless text processing — no data is stored, logged, or retained. No authentication required for free tier. Rate limiting uses IP hashing only.
