---
name: testosterone-optimization
description: Optimize natural testosterone with sleep, exercise, nutrition, and lifestyle tracking
author: clawd-team
version: 1.0.0
triggers:
  - "optimize testosterone"
  - "boost test naturally"
  - "testo check"
  - "hormone optimization"
  - "test levels"
---

# Testosterone Optimization

Naturally optimize hormone balance through evidence-based lifestyle factors and persistent progress tracking.

## What it does

Tracks the core lifestyle variables that influence testosterone production: sleep quality, resistance training volume, micronutrient intake, stress levels, and body composition. Logs symptom changes (energy, recovery, mood, libido) against adherence to each protocol factor. Builds a personal baseline, detects patterns, and highlights which interventions move the needle most for your biology.

## Usage

**Log Lifestyle Factors**
Record daily: sleep hours and quality, compound lifts performed, Vitamin D intake, Zinc intake, stress level (1-10), and body fat estimates. Simple entries—no precision required.

**Check Protocol**
Review current targets for sleep (7-9 hours), compound lift frequency (3x/week minimum), Vitamin D (2000-4000 IU), Zinc (30mg), stress management practice, and body fat range. Get a quick summary of where you stand today.

**Track Symptoms**
Log subjective markers: energy levels, workout recovery speed, mood stability, libido, morning erections, muscle hardness. Compare these against the lifestyle data to isolate what actually works for you.

**Set Goals**
Define personal targets: "Sleep 8 hours 5 nights/week," "Hit 3 compound sessions weekly," "Reduce stress score by 2 points," "Drop 3% body fat." Goals anchor your tracking to actionable objectives.

**Review Progress**
View 4-week rolling summaries. See correlations between lifestyle adherence and symptom improvements. Identify your biggest leverage points (e.g., "Sleep consistency correlates strongest with energy and recovery").

## Key Factors

- **Sleep (7-9 hours)** — Testosterone peaks during REM; insufficient sleep tanks production. Consistency matters more than perfection.
- **Compound Lifts** — Squats, deadlifts, bench press 3x weekly. Triggers testosterone and luteinizing hormone response.
- **Vitamin D** — 2000-4000 IU daily. Deficiency directly suppresses free testosterone; most people are deficient.
- **Zinc** — 30mg daily. Essential cofactor for testosterone synthesis and sexual function.
- **Stress Management** — Cortisol suppresses testosterone. Daily meditation, walks, or cold exposure mitigates this.
- **Body Fat** — Aromatase in fat tissue converts testosterone to estrogen. 10-15% body fat range optimizes hormonal balance.

## Tips

1. **Start with one factor.** Don't overhaul everything at once. Pick sleep or one lift per week, nail it for 3 weeks, then add the next lever.

2. **Symptoms lag lifestyle changes by 2-4 weeks.** Testosterone adapts slowly. Track anyway—patterns emerge in month 2.

3. **Track don't obsess.** Simple daily log takes 2 minutes. Use the data to make one decision per month, then let biology work.

4. **Compound lifts beat cardio.** Heavy resistance training (squats, deadlifts, bench) drives testosterone more than steady-state cardio. Prioritize strength.

5. **All data stays local on your machine.** Your hormone tracking, logs, and personal health data never leave your device. Complete privacy.
