---
name: test-upload-2026
description: Test upload skill for validating the clawhub publish workflow with meaningful content.
metadata:
  {
    "openclaw":
      {
        "emoji": "🧪"
      }
  }
---

# Test Upload 2026

This is a comprehensive test skill to validate the ClawHub publish workflow.

## Purpose

This skill serves as a validation mechanism for the publishing process, ensuring that:
- SKILL.md parsing works correctly
- Content quality requirements are met
- Metadata validation passes
- Upload functionality operates as expected

## Features

- **Validation Testing**: Comprehensive test of ClawHub publish workflow
- **Content Quality**: Meets minimum content requirements with detailed documentation
- **Metadata Compliance**: Properly formatted YAML frontmatter with required fields
- **Workflow Verification**: Confirms end-to-end skill publishing capability

## Usage

This skill doesn't provide actual functionality but serves as a proof-of-concept for the publishing pipeline.

## Requirements

- OpenClaw v2026.2.9 or later
- ClawHub CLI v0.7.0 or later
- Internet connectivity for registry access

## Development Notes

Created on February 28, 2026 as part of troubleshooting the ClawHub publish workflow.
This skill demonstrates proper SKILL.md structure and content depth requirements.

## Related Skills

- session-monitor: Real monitoring skill
- task-persistence: Real persistence skill  
- new-player-package-800: Comprehensive deployment optimization guide