# Documentation

Complete documentation for Terraform AI Skills.

## 📖 Essential Reading

Start here for quick understanding:

| Document | Purpose | Reading Time |
|----------|---------|--------------|
| [QUICKREF.md](QUICKREF.md) | Command cheat sheet | 2 min |
| [SAFETY.md](SAFETY.md) | Safety procedures and rollback | 10 min |
| [USAGE.md](USAGE.md) | Detailed workflows and best practices | 8 min |

## 📚 Reference Documentation

| Document | Content |
|----------|---------|
| [INDEX.md](INDEX.md) | Complete navigation guide for all files |
| [SKILL.md](SKILL.md) | AI assistant skill definition (YAML + instructions) |
| [EXAMPLES.md](EXAMPLES.md) | Real-world usage scenarios |
| [PROVIDER-SELECTION.md](PROVIDER-SELECTION.md) | Cloud provider configuration guide |
| [ENV-VARS.md](ENV-VARS.md) | Environment variables reference |
| [VERSION.md](VERSION.md) | Version compatibility matrix |
| [DISTRIBUTION.md](DISTRIBUTION.md) | Package distribution overview |

## 🚀 Quick Navigation

**New User?**
1. Read [QUICKREF.md](QUICKREF.md) for commands
2. Review [SAFETY.md](SAFETY.md) thoroughly
3. Check [EXAMPLES.md](EXAMPLES.md) for common scenarios

**Advanced User?**
1. [USAGE.md](USAGE.md) for detailed workflows
2. [PROVIDER-SELECTION.md](PROVIDER-SELECTION.md) for multi-cloud
3. [ENV-VARS.md](ENV-VARS.md) for customization

**Troubleshooting?**
1. Check [SAFETY.md](SAFETY.md) § Rollback Procedures
2. Review [EXAMPLES.md](EXAMPLES.md) for similar scenarios
3. See [INDEX.md](INDEX.md) for complete file listing

## 📂 Documentation Structure

```
docs/
├── README.md                 # This file
├── QUICKREF.md              # Command cheat sheet
├── SAFETY.md                # Safety procedures
├── USAGE.md                 # Detailed workflows
├── EXAMPLES.md              # Real-world scenarios
├── SKILL.md                 # AI assistant integration
├── INDEX.md                 # Complete navigation
├── PROVIDER-SELECTION.md    # Provider configs
├── ENV-VARS.md              # Variables reference
├── VERSION.md               # Compatibility matrix
└── DISTRIBUTION.md          # Distribution guide
```

## 🔗 External Links

- [Main README](../README.md) - Repository overview
- [CHANGELOG](../CHANGELOG.md) - Version history
- [CONTRIBUTING](../CONTRIBUTING.md) - Contribution guide
- [SECURITY](../SECURITY.md) - Security policy

---

**Need Help?** See [INDEX.md](INDEX.md) for complete navigation or [open an issue](https://github.com/anmolnagpal/terraform-ai-skills/issues)
