# Puerto de la Cruz & North — Traditional Tenerife

## Overview

The north coast offers Tenerife's most authentic tourist experience:
- **Puerto de la Cruz**: Traditional resort town, botanical gardens, culture
- **La Orotava**: Historic noble town, stunning valley views
- **Icod de los Vinos**: Dragon tree, wine region
- **Garachico**: Historic port, natural pools

This is where European tourism to the Canaries began in the late 19th century.

---

## Puerto de la Cruz

### Character
The original Tenerife tourist town, with 130+ years of welcoming visitors. Unlike the purpose-built south, this is a real Spanish town that became a resort.

- Historic seafront promenade
- Lago Martiánez (César Manrique pools)
- Botanical Garden (oldest in Canaries)
- Real neighborhood life
- German/British expat communities
- Excellent restaurants
- Cloud risk but often clears

### Areas Within Puerto

**Casco / Centro Histórico**
- Historic heart, pedestrian streets
- Plaza del Charco (main square)
- Best restaurants and bars
- Rent: €650-950/month (1BR)

**La Paz**
- Residential, above center
- Quieter, gardens
- Local families
- Rent: €550-800/month (1BR)

**Martiánez**
- Near the famous pools
- Good beach access
- Tourist hotels
- Rent: €700-1,000/month (1BR)

**San Antonio**
- Upper residential
- Valley views
- More space, gardens
- Rent: €600-900/month (1BR)

### Key Attractions
- **Lago Martiánez**: César Manrique-designed salt water pools
- **Jardín Botánico**: 200-year-old tropical garden
- **Playa Jardín**: Black sand beach (Manrique designed)
- **Casa de la Real Aduana**: Historic customs house
- **Loro Parque**: 3km away, world-famous zoo

### Weather Reality
- Cloudier than south, especially mornings
- Often clears by early afternoon
- 18-25°C year-round (pleasant)
- More rain Oct-Feb, still mild
- "If you don't like the weather, wait an hour"

---

## La Orotava

### Character
Noble town of historic mansions and the most beautiful valley on the island. UNESCO candidate.

- Colonial architecture
- Casa de los Balcones (famous carved balconies)
- Corpus Christi flower carpets (June)
- Orotava Valley views to Teide
- Local wine production
- Authentic daily life

### Living There
- More residential, less tourist
- Traditional Spanish small town
- Good base for Teide access
- Rent: €500-750/month (1BR)
- Limited nightlife

---

## Icod de los Vinos

### Character
Small wine town famous for its 1,000-year-old dragon tree.

- Drago Milenario (ancient tree)
- Wine cellars and guachinches
- Traditional Canarian atmosphere
- Day trip destination
- Quiet living

### Living There
- Very quiet, local life
- Good for wine enthusiasts
- Limited services
- Rent: €400-600/month (1BR)
- Car essential

---

## Garachico

### Character
Historic port town destroyed by 1706 volcanic eruption, beautifully preserved.

- Natural lava pools (El Caletón)
- San Miguel castle
- Historic convents and churches
- Artisan shops
- Day trip favorite
- One of most picturesque towns

### Living There
- Very small (5,000 people)
- Tight-knit community
- Swimming in natural pools daily
- Rent: €400-600/month (1BR)
- Quiet to extremely quiet

---

## North Coast Lifestyle

### Pros
- Authentic Canarian culture
- Best restaurant scenes
- More affordable than south
- Greener landscapes
- Cooler temperatures (pleasant, not cold)
- Less touristy feel
- Beautiful historic architecture
- Access to Anaga and Teide

### Cons
- Less beach weather
- Clouds can linger
- Fewer young nomad community
- Nightlife limited outside Puerto
- Car more necessary

---

## Cost Comparison

| Item | Puerto de la Cruz | La Orotava | Icod/Garachico |
|------|------------------|------------|----------------|
| 1BR | €650-950 | €500-750 | €400-600 |
| 2BR | €850-1,200 | €700-950 | €550-800 |
| Coffee | €1.20-1.60 | €1.00-1.40 | €1.00-1.30 |
| Menu del día | €10-13 | €8-12 | €8-11 |
| Beach/pool access | Free/€5 | N/A (no beach) | Free |

---

## For Digital Nomads

### Puerto de la Cruz
- **Coworking**: Limited formal options; good cafes
- **WiFi cafes**: Café Ebano, La Tasca
- **Community**: Small, older nomad demographic
- **Best for**: Those prioritizing culture over social scene

### Work Setup
- Fiber available in towns
- Mobile coverage good
- Backup options limited in small towns
- Santa Cruz/La Laguna 30-40 min if needed

---

## Getting Around

### From Puerto de la Cruz

| Destination | Time | Transport |
|-------------|------|-----------|
| La Laguna | 35 min | Bus (regular) |
| Santa Cruz | 45 min | Bus |
| Teide | 1h 15 min | Car |
| Los Cristianos | 1h 30 min | Bus/car |
| La Orotava | 15 min | Bus/car |
| Airport North | 30 min | Bus/car |
| Airport South | 1h 15 min | Bus/car |

### Public Transport
- Regular buses to Santa Cruz/La Laguna
- Local buses connect valley towns
- Taxis available but less than south
- Car highly recommended for exploration

---

## Food Scene

The north has Tenerife's best dining:

### Puerto de la Cruz
- **Tito's Bodeguita**: Tapas institution
- **Régulo**: Fine dining in historic house
- **El Patio**: Traditional Canarian
- **Compostelano**: Fresh seafood

### La Orotava Valley
- Guachinches (home wine restaurants) — ask locals for current open ones
- **El Portillo**: Canarian near Teide
- **Casa Lercaro**: Historic mansion dining

### What to Try
- Papas arrugadas con mojo
- Gofio escaldado
- Ropa vieja
- Puchero canario
- Local wines (DO Tacoronte-Acentejo)

---

## Activities

### Water
- Lago Martiánez (pools) — €5.50 adult
- Playa Jardín (beach, free)
- Surfing at nearby beaches
- Diving operators in Puerto

### Land
- Hiking: Anaga (30 min), Teide (1h 15 min)
- Golf: Buenavista (40 min)
- Wine routes: Tacoronte-Acentejo
- Cycling: Valley and mountain routes

### Culture
- Loro Parque (love it or hate it)
- Botanical Garden
- La Orotava architecture walks
- Local fiestas (check calendars)
- Carnival (smaller than Santa Cruz, still fun)

---

## Who Should Live Here

**Puerto de la Cruz**:
- Culture-seeking retirees
- Food lovers
- Traditional tourism appreciators
- Those okay with variable weather
- Anyone wanting real Spanish life

**La Orotava**:
- Deep authenticity seekers
- Wine enthusiasts
- Traditional Spanish lifestyle
- Families wanting local school integration

**Icod/Garachico**:
- Peace and quiet priority
- Budget maximizers
- Wine lovers
- Those okay with isolation

**Go south instead if**:
- Beach is daily essential
- Need guaranteed sun
- Want active nomad community
- Nightlife important
