# Visas & Residency — Tenerife

## Overview by Nationality

| Nationality | Short Stay | Long Stay | Work |
|-------------|------------|-----------|------|
| EU/EEA/Swiss | Unlimited | Register after 90 days | Full rights |
| UK (post-Brexit) | 90/180 days | Visa required | Visa required |
| US/Canada/Australia | 90/180 days | Visa required | Visa required |
| Others | Varies | Usually visa required | Visa required |

---

## EU/EEA Citizens

### Short Stays
- No registration needed
- Full right to be in Spain
- Can look for work

### Long-Term (90+ days)

**Registration Process**
1. Get appointment at Oficina de Extranjeros
2. Bring:
   - Passport/ID
   - Application form (EX-18)
   - Proof of resources:
     - Employment contract, OR
     - Self-employment registration, OR
     - Proof of funds + health insurance (if not working)
3. Receive green NIE certificate (Certificado de Registro)

**Requirements to Show**
One of:
- Employment in Spain
- Self-employment (autónomo)
- Sufficient resources (€600+/month) + health insurance
- Student enrollment + insurance

### Timeline
- Appointment: Book early (fills up)
- Same-day certificate usually
- Permanent residence after 5 years

---

## UK Citizens (Post-Brexit)

### Short Stay
- 90 days in any 180-day period
- Schengen zone rules apply
- Tourist activities only
- Cannot work

### For Longer Stay

**Options**
1. Spain Digital Nomad Visa
2. Non-lucrative visa
3. Student visa
4. Work visa (employer-sponsored)
5. Golden visa (investment)
6. Entrepreneur visa

**Most Common for Remote Workers**: Digital Nomad Visa

---

## Spain Digital Nomad Visa (2023+)

### Overview
- Allows remote work for non-Spanish companies
- 1 year initial, renewable to 3 years
- Path to residence permit

### Requirements

**Income**
- €3,000+/month (200% of Spanish minimum wage)
- Proof via contracts, invoices, bank statements
- Must be from non-Spanish employer/clients

**Employment**
- Working remotely for non-Spanish company, OR
- Self-employed with non-Spanish clients
- Max 20% revenue from Spanish clients

**Other Requirements**
- No criminal record
- Health insurance (coverage in Spain)
- Bachelor's degree OR 3+ years experience
- Company must be 1+ year old (if employed)
- Proof of accommodation

### Application Process

**Option A: Apply from Home Country**
1. Gather documents
2. Apply at Spanish consulate
3. Wait for approval (varies, 1-3 months)
4. Travel to Spain
5. Get TIE card (residence permit)

**Option B: Apply in Spain (if already here legally)**
1. Enter as tourist
2. Apply at immigration office
3. Wait for approval
4. Receive permit
5. Can stay while processing

### Costs
| Item | Cost |
|------|------|
| Visa fee | €80 |
| TIE card | €16-20 |
| Translations | €100-300 |
| Apostilles | €50-150 |
| Legal help | €500-1,500 |

### Documents Needed
- Valid passport (6+ months validity)
- Application form
- Photos
- Criminal background check (apostilled)
- Health insurance certificate
- Proof of income (contracts, statements)
- Proof of work arrangement
- Academic qualifications or experience proof
- Proof of accommodation

### Renewal
- Apply before expiry
- Show continued compliance
- 2-year renewal possible
- After 5 years: permanent residence

---

## Other Visa Options

### Non-Lucrative Visa
- Cannot work
- Must show €2,400+/month passive income
- Health insurance required
- Good for retirees, FIRE, etc.
- 1 year, renewable

### Student Visa
- Enrolled in recognized program
- Limited work permitted (20 hrs/week)
- Health insurance required
- Duration matches course

### Golden Visa
- €500,000+ real estate investment
- Or €1M+ in stocks/bonds
- Or €1M+ bank deposit
- No minimum stay requirement
- Family included

### Entrepreneur Visa
- Viable business plan
- Beneficial for Spain
- Investment capability
- More complex process

---

## NIE (Número de Identidad de Extranjero)

### What It Is
Your foreigner identification number. Essential for everything.

### How to Get

**EU Citizens**
- Part of registration process
- Apply at Oficina de Extranjeros
- Usually same-day

**Non-EU with Visa**
- Issued with visa/TIE card
- Or apply separately if needed before TIE

**Temporary NIE (for transactions)**
- Can get for specific purpose
- Valid 3 months
- Apply at police station with appointment

### Why You Need It
- Bank account
- Work contract
- Rent contract
- Utilities
- Car purchase
- Property purchase
- Tax declarations
- Everything official

---

## TIE Card (Tarjeta de Identidad de Extranjero)

### What It Is
Physical ID card for non-EU long-term residents.

### When Required
- Non-EU staying 6+ months
- After visa approval in Spain
- Must apply within 30 days of arrival

### Application
1. Book appointment (cita previa)
2. Go to police station
3. Bring documents + fee
4. Fingerprints taken
5. Collect card later (2-4 weeks)

---

## Practical Tips

### Appointment Booking
- Use sede.administracion.gob.es
- Books up weeks ahead
- Check daily for cancellations
- Try different locations

### Document Preparation
- Apostille criminal records in home country
- Official translations (sworn translator)
- Make multiple copies
- Keep originals safe

### Timing
- Start 3+ months before planned move
- Some documents have validity periods
- Plan around appointment availability

### Getting Help
- Immigration lawyers: €500-2,000
- Gestorías: Cheaper for simple cases
- Online services available
- Worth it for complex situations

---

## Family Members

### EU Citizen Family
- Non-EU spouse/children can join
- Apply as family member of EU citizen
- Easier than independent visa

### Non-EU Holder Family
- Digital nomad visa includes family
- Each needs documentation
- Can work with same status

---

## After 5 Years

### Permanent Residence
- Available after 5 years legal residence
- No need to renew
- More stability

### Citizenship
- Available after 10 years (general)
- Or 2 years (Latin Americans, others)
- Requires Spanish language test
- Some countries don't allow dual citizenship

---

## Common Mistakes

### Avoid
- Overstaying 90-day limit
- Working on tourist status
- Not registering when required
- Missing renewal deadlines
- Incomplete applications

### Do
- Plan ahead
- Keep documents organized
- Track dates carefully
- Get professional help if unsure
- Apply before expiry for renewals
